"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedPublicPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _newsfeed_header_nav_button = require("./components/newsfeed_header_nav_button");
var _api = require("./lib/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/newsfeed/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class NewsfeedPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "stop$", new Rx.ReplaySubject(1));
    this.isServerless = initializerContext.env.packageInfo.buildFlavor === 'serverless';
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    const config = initializerContext.config.get();
    this.config = Object.freeze({
      ...config,
      // We need wrap them in moment.duration because exposeToBrowser stringifies it.
      mainInterval: _moment.default.duration(config.mainInterval),
      fetchInterval: _moment.default.duration(config.fetchInterval)
    });
  }
  setup(_core) {
    return {};
  }
  start(core, {
    screenshotMode
  }) {
    const isScreenshotMode = screenshotMode.isScreenshotMode();
    const api = this.createNewsfeedApi(this.config, _api.NewsfeedApiEndpoint.KIBANA, isScreenshotMode);
    core.chrome.navControls.registerRight({
      order: 1000,
      mount: target => this.mount(api, target, core)
    });
    return {
      createNewsFeed$: endpoint => {
        const config = Object.assign({}, this.config, {
          service: {
            ...this.config.service,
            pathTemplate: `/${endpoint}/v{VERSION}.json`
          }
        });
        const {
          fetchResults$
        } = this.createNewsfeedApi(config, endpoint, isScreenshotMode);
        return fetchResults$;
      }
    };
  }
  stop() {
    this.stop$.next();
  }
  createNewsfeedApi(config, newsfeedId, isScreenshotMode) {
    const api = (0, _api.getApi)(config, this.kibanaVersion, newsfeedId, isScreenshotMode);
    return {
      markAsRead: api.markAsRead,
      fetchResults$: api.fetchResults$.pipe((0, _rxjs.takeUntil)(this.stop$),
      // stop the interval when stop method is called
      (0, _rxjs.catchError)(() => Rx.of(null)) // do not throw error
      )
    };
  }
  mount(api, targetDomElement, core) {
    const hasCustomBranding$ = core.customBranding.hasCustomBranding$;
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_newsfeed_header_nav_button.NewsfeedNavButton, {
      newsfeedApi: api,
      hasCustomBranding$: hasCustomBranding$,
      isServerless: this.isServerless,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    })), targetDomElement);
    return () => _reactDom.default.unmountComponentAtNode(targetDomElement);
  }
}
exports.NewsfeedPublicPlugin = NewsfeedPublicPlugin;