"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionNavigationTourManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tourQueue = require("@kbn/tour-queue");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This tour combines the spaces solution view tour and new navigation tour into a single
 * multi-step tour.
 */
class SolutionNavigationTourManager {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "tourQueue", (0, _tourQueue.getTourQueue)());
    this.deps = deps;
  }
  async startTour() {
    // Register and get tour object
    const tour = this.tourQueue.register('solutionNavigationTour');
    // This will only work as long as solutionNavigationTour is the first tour in the queue
    // Will be removed as part of tour cleanup https://github.com/elastic/kibana/issues/239313
    if (!tour.isActive()) {
      tour.unregister();
      return;
    }
    try {
      // first start the spaces tour (if applicable)
      if (this.deps.spacesSolutionViewTourManager) {
        const spacesTour = await this.deps.spacesSolutionViewTourManager.startTour();
        if (spacesTour.result === 'started') {
          await this.deps.spacesSolutionViewTourManager.waitForTourEnd();
        }
      }

      // when completes, maybe start the navigation tour (if applicable)
      const hasCompletedTour = await checkTourCompletion(this.deps.userProfile);
      if (hasCompletedTour) {
        tour.complete();
        return;
      }
      this.deps.navigationTourManager.startTour();
      const navigationTourResult = await this.deps.navigationTourManager.waitForTourEnd();

      // If skipped, notify queue to skip all remaining tours for the current page load only
      if (navigationTourResult === 'skipped') {
        tour.skip();
      }
      await preserveTourCompletion(this.deps.userProfile);
      tour.complete();
    } finally {
      tour.unregister();
    }
  }
}
exports.SolutionNavigationTourManager = SolutionNavigationTourManager;
const SOLUTION_NAVIGATION_TOUR_KEY = 'solutionNavigationTour:completed';
async function preserveTourCompletion(userProfile) {
  try {
    localStorage.setItem(SOLUTION_NAVIGATION_TOUR_KEY, 'true');
    return await userProfile.partialUpdate({
      [SOLUTION_NAVIGATION_TOUR_KEY]: true
    });
  } catch (e) {
    // ignore
  }
}
async function checkTourCompletion(userProfile) {
  try {
    var _profile$data;
    const localValue = localStorage.getItem(SOLUTION_NAVIGATION_TOUR_KEY) === 'true';
    if (localValue) return true;
    const profile = await userProfile.getCurrent({
      dataPath: SOLUTION_NAVIGATION_TOUR_KEY
    });
    if (!profile) return true; // consider completed if we can't fetch the profile

    return ((_profile$data = profile.data) === null || _profile$data === void 0 ? void 0 : _profile$data[SOLUTION_NAVIGATION_TOUR_KEY]) === true;
  } catch (e) {
    // consider completed
    return true;
  }
}