"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _top_nav_menu = require("./top_nav_menu");
var _solution_tour = require("./solution_tour/solution_tour");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class NavigationPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "topNavMenuExtensionsRegistry", new _top_nav_menu.TopNavMenuExtensionsRegistry());
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "isSolutionNavEnabled", false);
    (0, _defineProperty2.default)(this, "isCloudTrialUser", false);
    this.initializerContext = initializerContext;
  }
  setup(core, deps) {
    var _deps$cloud$isInTrial, _deps$cloud;
    this.isCloudTrialUser = (_deps$cloud$isInTrial = (_deps$cloud = deps.cloud) === null || _deps$cloud === void 0 ? void 0 : _deps$cloud.isInTrial()) !== null && _deps$cloud$isInTrial !== void 0 ? _deps$cloud$isInTrial : false;
    return {
      registerMenuItem: this.topNavMenuExtensionsRegistry.register.bind(this.topNavMenuExtensionsRegistry)
    };
  }
  start(core, depsStart) {
    var _spaces$getActiveSpac, _spaces$isSolutionVie;
    this.coreStart = core;
    const {
      unifiedSearch,
      cloud,
      spaces
    } = depsStart;
    const extensions = this.topNavMenuExtensionsRegistry.getAll();
    const chrome = core.chrome;
    const activeSpace$ = (_spaces$getActiveSpac = spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace$()) !== null && _spaces$getActiveSpac !== void 0 ? _spaces$getActiveSpac : (0, _rxjs.of)(undefined);
    const isServerless = this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
    this.isSolutionNavEnabled = (_spaces$isSolutionVie = spaces === null || spaces === void 0 ? void 0 : spaces.isSolutionViewEnabled) !== null && _spaces$isSolutionVie !== void 0 ? _spaces$isSolutionVie : false;

    /*
     *
     *  This helps clients of navigation to create
     *  a TopNav Search Bar which does not uses global unifiedSearch/data/query service
     *
     *  Useful in creating multiple stateful SearchBar in the same app without affecting
     *  global filters
     *
     * */
    const createCustomTopNav = (customUnifiedSearch, customExtensions) => {
      return (0, _top_nav_menu.createTopNav)(customUnifiedSearch !== null && customUnifiedSearch !== void 0 ? customUnifiedSearch : unifiedSearch, customExtensions !== null && customExtensions !== void 0 ? customExtensions : extensions);
    };
    const initSolutionNavigation = activeSpace => {
      var _cloud$isCloudEnabled;
      this.initiateChromeStyleAndSideNav(chrome, {
        isServerless,
        activeSpace
      });
      const feedbackUrlParams = this.buildFeedbackUrlParams(isServerless, (_cloud$isCloudEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) !== null && _cloud$isCloudEnabled !== void 0 ? _cloud$isCloudEnabled : false);
      chrome.project.setFeedbackUrlParams(feedbackUrlParams);
      if (!this.isSolutionNavEnabled) return;
      if (cloud) {
        chrome.project.setCloudUrls(cloud.getUrls()); // Ensure the project has the non-privileged URLs immediately
        cloud.getPrivilegedUrls().then(privilegedUrls => {
          if (Object.keys(privilegedUrls).length === 0) return;
          chrome.project.setCloudUrls({
            ...privilegedUrls,
            ...cloud.getUrls()
          }); // Merge the privileged URLs once available
        });
      }
    };
    if (this.getIsUnauthenticated(core.http)) {
      // Don't fetch the active space if the user is not authenticated
      initSolutionNavigation();
    } else {
      activeSpace$.pipe((0, _rxjs.take)(1)).subscribe(initSolutionNavigation);
    }
    if (this.isSolutionNavEnabled || isServerless) {
      const hideAnnouncements = core.settings.client.get('hideAnnouncements', false);
      if (!hideAnnouncements) {
        const {
          project
        } = core.chrome;
        const tourManager = new _solution_tour.SolutionNavigationTourManager({
          navigationTourManager: project.navigationTourManager,
          spacesSolutionViewTourManager: spaces === null || spaces === void 0 ? void 0 : spaces.solutionViewTourManager,
          userProfile: core.userProfile,
          capabilities: core.application.capabilities,
          featureFlags: core.featureFlags
        });
        void tourManager.startTour();
      }
    }
    return {
      ui: {
        TopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions),
        AggregateQueryTopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions),
        createTopNavWithCustomContext: createCustomTopNav
      },
      addSolutionNavigation: solutionNavigation => {
        if (!this.isSolutionNavEnabled) return;
        this.addSolutionNavigation(solutionNavigation);
      },
      isSolutionNavEnabled$: (0, _rxjs.of)(this.getIsUnauthenticated(core.http)).pipe((0, _rxjs.switchMap)(isUnauthenticated => {
        if (isUnauthenticated) return (0, _rxjs.of)(false);
        return activeSpace$.pipe((0, _rxjs.map)(activeSpace => {
          return this.isSolutionNavEnabled && getIsProjectNav(activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution);
        }));
      }))
    };
  }
  stop() {
    this.stop$.next();
  }
  addSolutionNavigation(solutionNavigation) {
    if (!this.coreStart) throw new Error('coreStart is not available');
    const {
      project
    } = this.coreStart.chrome;
    project.updateSolutionNavigations({
      [solutionNavigation.id]: solutionNavigation
    });
  }
  initiateChromeStyleAndSideNav(chrome, {
    isServerless,
    activeSpace
  }) {
    const solutionView = activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution;
    const isProjectNav = this.isSolutionNavEnabled && getIsProjectNav(solutionView);

    // On serverless the chrome style is already set by the serverless plugin
    if (!isServerless) {
      chrome.setChromeStyle(isProjectNav ? 'project' : 'classic');
      if (isProjectNav) {
        chrome.sideNav.setIsFeedbackBtnVisible(!this.isCloudTrialUser);
      }
    }
    if (isProjectNav && solutionView !== 'classic') {
      chrome.project.changeActiveSolutionNavigation(solutionView);
    }
  }
  getIsUnauthenticated(http) {
    const {
      anonymousPaths
    } = http;
    return anonymousPaths.isAnonymous(window.location.pathname);
  }
  buildFeedbackUrlParams(isServerless, isCloudEnabled) {
    const version = this.initializerContext.env.packageInfo.version;
    const type = isServerless ? 'serverless' : isCloudEnabled ? 'ech' : 'local';
    return new URLSearchParams({
      version,
      type
    });
  }
}
exports.NavigationPublicPlugin = NavigationPublicPlugin;
function getIsProjectNav(solutionView) {
  return Boolean(solutionView) && isKnownSolutionView(solutionView);
}
function isKnownSolutionView(solution) {
  return Boolean(solution) && ['oblt', 'es', 'security'].includes(solution);
}