"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailStatus = DetailStatus;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _external_config_context = require("../../../application/contexts/external_config_context");
var _format_number = require("../../../lib/format_number");
var _summary_status = require("../../summary_status");
var _format_last_seen_timestamp = require("../format_last_seen_timestamp");
var _status_icon = require("../status_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/kibana/detail_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const summaryStatusNoWrapStatStyle = (0, _react2.css)`
  p {
    ${(0, _eui.euiTextTruncate)()}
  }
`;
function DetailStatus({
  stats
}) {
  const {
    transport_address: transportAddress,
    os_memory_free: osFreeMemory,
    version,
    uptime,
    status,
    statusIsStale,
    lastSeenTimestamp
  } = stats;
  const {
    staleStatusThresholdSeconds
  } = _react.default.useContext(_external_config_context.ExternalConfigContext);
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.transportAddressLabel', {
      defaultMessage: 'Transport Address'
    }),
    value: transportAddress,
    'data-test-subj': 'transportAddress'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.osFreeMemoryLabel', {
      defaultMessage: 'OS Free Memory'
    }),
    value: (0, _format_number.formatMetric)(osFreeMemory, 'byte'),
    'data-test-subj': 'osFreeMemory'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.versionLabel', {
      defaultMessage: 'Version'
    }),
    value: version,
    'data-test-subj': 'version'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.uptimeLabel', {
      defaultMessage: 'Uptime'
    }),
    value: (0, _format_number.formatMetric)(uptime, 'time_since'),
    'data-test-subj': 'uptime'
  }];
  const StatusIndicator = () => {
    if (!statusIsStale) {
      return /*#__PURE__*/_react.default.createElement(_summary_status.DefaultStatusIndicator, {
        status: status,
        isOnline: true,
        IconComponent: _status_icon.KibanaStatusIcon,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      });
    }
    const {
      description,
      title
    } = prepareStaleMessage(status, lastSeenTimestamp, staleStatusThresholdSeconds, dateFormat);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      css: summaryStatusNoWrapStatStyle,
      "data-test-subj": "status",
      description: description,
      textAlign: "left",
      title: title,
      titleSize: "xxxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    StatusIndicator: StatusIndicator,
    metrics: metrics,
    "data-test-subj": "kibanaDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  });
}
function prepareStaleMessage(status, lastSeenTimestamp, staleStatusThresholdSeconds, dateFormat) {
  const {
    shouldShowRelativeTime,
    relativeTime,
    formattedTimestamp
  } = (0, _format_last_seen_timestamp.formatLastSeenTimestamp)(lastSeenTimestamp, dateFormat);
  const staleMessage = _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.staleStatusTooltip', {
    defaultMessage: "It's been more than {staleStatusThresholdSeconds} seconds since we have heard from this instance. Last seen: {lastSeenTimestamp}",
    values: {
      staleStatusThresholdSeconds,
      lastSeenTimestamp: shouldShowRelativeTime ? relativeTime : formattedTimestamp
    }
  });
  const description = _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.staleStatusMetricDescription', {
    defaultMessage: 'Last Reported Status'
  });
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_status_icon.KibanaStatusIcon, {
    status: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), "\xA0", (0, _lodash.capitalize)(status), /*#__PURE__*/_react.default.createElement("span", {
    style: {
      marginLeft: '8px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: staleMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    iconType: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.monitoring.kibana.detailStatus.staleStatusLabel', {
    defaultMessage: 'Stale'
  })))));
  return {
    description,
    title
  };
}