"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterStatus = ClusterStatus;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _external_config_context = require("../../../application/contexts/external_config_context");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/kibana/cluster_status/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const summaryStatusNoWrapStatStyle = (0, _react2.css)`
  p {
    ${(0, _eui.euiTextTruncate)()}
  }
`;
function ClusterStatus({
  stats,
  alerts
}) {
  const {
    concurrent_connections: connections,
    count: instances,
    memory_limit: memLimit,
    memory_size: memSize,
    requests_total: requests,
    response_time_max: maxResponseTime,
    status,
    some_status_is_stale: someStatusIsStale
  } = stats;
  const {
    staleStatusThresholdSeconds
  } = _react.default.useContext(_external_config_context.ExternalConfigContext);
  const location = (0, _reactRouterDom.useLocation)();
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.instancesLabel', {
      defaultMessage: 'Instances'
    }),
    value: instances,
    'data-test-subj': 'instances'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.memoryLabel', {
      defaultMessage: 'Memory'
    }),
    value: (0, _format_number.formatMetric)(memSize, 'byte') + ' / ' + (0, _format_number.formatMetric)(memLimit, 'byte'),
    'data-test-subj': 'memory'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.requestsLabel', {
      defaultMessage: 'Requests'
    }),
    value: requests,
    'data-test-subj': 'requests'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.connectionsLabel', {
      defaultMessage: 'Connections'
    }),
    value: connections,
    'data-test-subj': 'connections'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.maxResponseTimeLabel', {
      defaultMessage: 'Max. Response Time'
    }),
    value: (0, _format_number.formatMetric)(maxResponseTime, '0', 'ms'),
    'data-test-subj': 'maxResponseTime'
  }];
  const StatusIndicator = () => {
    if (!someStatusIsStale) {
      return /*#__PURE__*/_react.default.createElement(_summary_status.DefaultStatusIndicator, {
        status: status,
        isOnline: true,
        IconComponent: _status_icon.KibanaStatusIcon,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      });
    }
    const staleMessage = _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.staleStatusTooltip', {
      defaultMessage: "It's been more than {staleStatusThresholdSeconds} seconds since we have heard from some instances.",
      values: {
        staleStatusThresholdSeconds
      }
    });
    if (location.pathname === '/kibana') {
      return /*#__PURE__*/_react.default.createElement(OverviewPageStatusIndicator, {
        staleMessage: staleMessage,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(InstancesPageStatusIndicator, {
      staleMessage: staleMessage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 12
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    StatusIndicator: StatusIndicator,
    alerts: alerts,
    metrics: metrics,
    "data-test-subj": "kibanaClusterStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
}
function OverviewPageStatusIndicator({
  staleMessage
}) {
  const instancesHref = (0, _get_safe_for_external_link.getSafeForExternalLink)('#/kibana/instances');
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: '8px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: staleMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    iconType: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.overview.staleStatusInstancesLabel', {
    defaultMessage: 'Stale'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: instancesHref,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.overview.staleStatusLinkToInstancesLabel', {
    defaultMessage: 'View all instances'
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "status",
    description: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.overview.statusLabel', {
      defaultMessage: 'Status'
    }),
    title: title,
    titleSize: "xxxs",
    textAlign: "left",
    css: summaryStatusNoWrapStatStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  });
}
function InstancesPageStatusIndicator({
  staleMessage
}) {
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: staleMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    iconType: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.instances.staleStatusInstancesLabel', {
    defaultMessage: 'Stale'
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "status",
    description: _i18n.i18n.translate('xpack.monitoring.kibana.clusterStatus.instances.statusLabel', {
      defaultMessage: 'Status'
    }),
    title: title,
    titleSize: "xxxs",
    textAlign: "left",
    css: summaryStatusNoWrapStatStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  });
}