"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _imported_events = require("../imported_events");
var _utils = require("./utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/calendars/edit/import_modal/import_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_FILE_SIZE_MB = 100;
class ImportModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleImport", async loadedFile => {
      const incomingFile = loadedFile[0];
      const errorMessage = _i18n.i18n.translate('xpack.ml.calendarsEdit.importModal.couldNotParseICSFileErrorMessage', {
        defaultMessage: 'Could not parse ICS file.'
      });
      let events = [];
      if (incomingFile && incomingFile.size <= MAX_FILE_SIZE_MB * 1000000) {
        this.setState({
          fileLoading: true,
          fileLoaded: true
        });
        try {
          const parsedFile = await (0, _utils.readFile)(incomingFile);
          events = (0, _utils.parseICSFile)(parsedFile.data);
          this.setState({
            allImportedEvents: events,
            selectedEvents: (0, _utils.filterEvents)(events),
            fileLoading: false,
            errorMessage: null,
            includePastEvents: false
          });
        } catch (error) {
          console.log(errorMessage, error);
          this.setState({
            errorMessage,
            fileLoading: false
          });
        }
      } else if (incomingFile && incomingFile.size > MAX_FILE_SIZE_MB * 1000000) {
        this.setState({
          fileLoading: false,
          errorMessage
        });
      } else {
        this.setState({
          fileLoading: false,
          errorMessage: null
        });
      }
    });
    (0, _defineProperty2.default)(this, "onEventDelete", eventId => {
      this.setState(prevState => ({
        allImportedEvents: prevState.allImportedEvents.filter(event => event.event_id !== eventId),
        selectedEvents: prevState.selectedEvents.filter(event => event.event_id !== eventId)
      }));
    });
    (0, _defineProperty2.default)(this, "onCheckboxToggle", e => {
      this.setState({
        includePastEvents: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "handleEventsAdd", () => {
      const {
        allImportedEvents,
        selectedEvents,
        includePastEvents
      } = this.state;
      const eventsToImport = includePastEvents ? allImportedEvents : selectedEvents;
      const events = eventsToImport.map(event => ({
        description: event.description,
        start_time: event.start_time,
        end_time: event.end_time,
        event_id: event.event_id
      }));
      this.props.addImportedEvents(events);
    });
    (0, _defineProperty2.default)(this, "renderCallout", () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, this.state.errorMessage)));
    this.state = {
      includePastEvents: false,
      allImportedEvents: [],
      selectedEvents: [],
      fileLoading: false,
      fileLoaded: false,
      errorMessage: null
    };
  }
  render() {
    const {
      closeImportModal
    } = this.props;
    const {
      fileLoading,
      fileLoaded,
      allImportedEvents,
      selectedEvents,
      errorMessage,
      includePastEvents
    } = this.state;
    const modalTitleId = (0, _eui.htmlIdGenerator)()('importModalTitle');
    let showRecurringWarning = false;
    let importedEvents;
    if (includePastEvents) {
      importedEvents = allImportedEvents;
    } else {
      importedEvents = selectedEvents;
    }
    if (importedEvents.find(e => e.asterisk) !== undefined) {
      showRecurringWarning = true;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeImportModal,
      maxWidth: true,
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsTitle",
      defaultMessage: "Import events",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsDescription",
      defaultMessage: "Import events from an ICS file.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      compressed: true,
      initialPromptText: _i18n.i18n.translate('xpack.ml.calendarsEdit.importModal.selectOrDragAndDropFilePromptText', {
        defaultMessage: 'Select or drag and drop a file'
      }),
      onChange: this.handleImport,
      disabled: fileLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    })), errorMessage !== null && this.renderCallout(), allImportedEvents.length > 0 && /*#__PURE__*/_react.default.createElement(_imported_events.ImportedEvents, {
      events: importedEvents,
      showRecurringWarning: showRecurringWarning,
      includePastEvents: includePastEvents,
      onCheckboxToggle: this.onCheckboxToggle,
      onEventDelete: this.onEventDelete,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeImportModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.handleEventsAdd,
      fill: true,
      disabled: fileLoaded === false || errorMessage !== null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importButtonLabel",
      defaultMessage: "Import",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 15
      }
    })))));
  }
}
exports.ImportModal = ImportModal;
(0, _defineProperty2.default)(ImportModal, "propTypes", {
  addImportedEvents: _propTypes.PropTypes.func.isRequired,
  closeImportModal: _propTypes.PropTypes.func.isRequired
});