"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlUsageCollectionProvider = mlUsageCollectionProvider;
var _analytics = require("@kbn/analytics");
var _app = require("../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mlUsageCollectionProvider(usageCollection) {
  if (usageCollection === undefined) {
    // if usageCollection is disabled, swallow the clicks and counts
    const noop = (eventNames, count) => undefined;
    return {
      click: noop,
      count: noop
    };
  }
  return {
    click: (eventNames, count) => usageCollection.reportUiCounter(_app.PLUGIN_ID, _analytics.METRIC_TYPE.CLICK, eventNames, count),
    count: (eventNames, count) => usageCollection.reportUiCounter(_app.PLUGIN_ID, _analytics.METRIC_TYPE.COUNT, eventNames, count)
  };
}