"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageWrapper = exports.MODE = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _kibana = require("../../../contexts/kibana");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _router = require("../../router");
var _index_or_search = require("../../../jobs/new_job/pages/index_or_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/new_job/index_or_search_page_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../jobs/new_job/pages/index_or_search')))).Page
}));
let MODE = exports.MODE = /*#__PURE__*/function (MODE) {
  MODE[MODE["NEW_JOB"] = 0] = "NEW_JOB";
  MODE[MODE["DATAVISUALIZER"] = 1] = "DATAVISUALIZER";
  return MODE;
}({});
const PageWrapper = ({
  nextStepPath,
  mode,
  extraButtons
}) => {
  const {
    services: {
      http: {
        basePath
      },
      application: {
        navigateToUrl
      },
      data: {
        dataViews: dataViewsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const newJobResolvers = {
    ...(0, _resolvers.basicResolvers)(),
    preConfiguredJobRedirect: () => (0, _index_or_search.preConfiguredJobRedirect)(dataViewsService, basePath.get(), navigateToUrl)
  };
  const {
    context
  } = (0, _use_resolver.useRouteResolver)(mode === MODE.NEW_JOB ? 'full' : 'basic', mode === MODE.NEW_JOB ? ['canCreateJob'] : [], mode === MODE.NEW_JOB ? newJobResolvers : {});
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Page, {
    nextStepPath,
    extraButtons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.PageWrapper = PageWrapper;