"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _model_link = require("../../../../../model_management/model_link");
var _job_id_link = require("../../../../../jobs/jobs_list/components/jobs_list/job_id_link");
var _use_columns = require("../../../../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/management/jobs_list/components/jobs_list_page/space_management/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getColumns(mlSavedObjectType) {
  switch (mlSavedObjectType) {
    case 'anomaly-detector':
      return adColumns;
    case 'data-frame-analytics':
      return dfaColumns;
    case 'trained-model':
      return trainedModelColumns;
    default:
      return [];
  }
}
const adColumns = [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.ad.id', {
    defaultMessage: 'ID'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnId',
  scope: 'row',
  width: '250px',
  render: id => /*#__PURE__*/_react.default.createElement(_job_id_link.AnomalyDetectionJobIdLink, {
    id: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 29
    }
  })
}, {
  field: 'description',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.ad.description', {
    defaultMessage: 'Description'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnDescription'
}, {
  field: 'jobState',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.ad.jobState', {
    defaultMessage: 'Job state'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnJobState',
  width: '100px'
}, {
  field: 'datafeedState',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.ad.datafeedState', {
    defaultMessage: 'Datafeed state'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnDatafeedState',
  width: '150px'
}];
const dfaColumns = [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.id', {
    defaultMessage: 'ID'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnId',
  scope: 'row',
  width: '250px',
  render: id => /*#__PURE__*/_react.default.createElement(_use_columns.DFAnalyticsJobIdLink, {
    jobId: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 29
    }
  })
}, {
  field: 'description',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.description', {
    defaultMessage: 'Description'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnDescription'
}, {
  field: 'source_index',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.source_index', {
    defaultMessage: 'Source index'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnSourceIndex',
  width: '200px'
}, {
  field: 'dest_index',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.dest_index', {
    defaultMessage: 'Destination index'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnDestIndex',
  width: '200px'
}, {
  field: 'job_type',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.job_type', {
    defaultMessage: 'Type'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnJobType',
  width: '150px'
}, {
  field: 'state',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.dfa.state', {
    defaultMessage: 'Status'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnState',
  width: '100px'
}];
const trainedModelColumns = [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.id', {
    defaultMessage: 'ID'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnId',
  scope: 'row',
  width: '250px',
  render: id => /*#__PURE__*/_react.default.createElement(_model_link.TrainedModelLink, {
    id: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 29
    }
  })
}, {
  field: 'description',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.description', {
    defaultMessage: 'Description'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnDescription'
}, {
  field: 'type',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.type', {
    defaultMessage: 'Type'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnType',
  width: '250px'
}, {
  field: 'state',
  name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.trainedModels.state', {
    defaultMessage: 'State'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlSpaceManagementTableColumnState',
  width: '100px'
}];