"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoFieldSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/geo_field/geo_field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GeoFieldSelect = ({
  fields,
  changeHandler,
  selectedField
}) => {
  const {
    optionCss
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => fields.map(f => ({
    label: f.name,
    field: f,
    css: optionCss
  })), [fields, optionCss]);
  const selection = (0, _react.useMemo)(() => {
    const selectedOptions = [];
    if (selectedField !== null) {
      selectedOptions.push({
        label: selectedField.name,
        field: selectedField
      });
    }
    return selectedOptions;
  }, [selectedField]);
  const onChange = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      changeHandler(option.field);
    } else {
      changeHandler(null);
    }
  }, [changeHandler]);
  return /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    isClearable: true,
    "data-test-subj": "mlGeoFieldNameSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};
exports.GeoFieldSelect = GeoFieldSelect;