"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeDataViewModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _use_create_url = require("../../../../../../../contexts/kibana/use_create_url");
var _job_creator_context = require("../../../job_creator_context");
var _general = require("../../../../../common/job_creator/util/general");
var _kibana = require("../../../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/datafeed_step/components/data_view/change_data_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fixedPageSize = 8;
var STEP = /*#__PURE__*/function (STEP) {
  STEP[STEP["PICK_DATA_VIEW"] = 0] = "PICK_DATA_VIEW";
  STEP[STEP["VALIDATE"] = 1] = "VALIDATE";
  return STEP;
}(STEP || {});
const ChangeDataViewModal = ({
  onClose
}) => {
  const {
    services: {
      data: {
        dataViews
      },
      contentManagement,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const navigateToMlManagementLink = (0, _use_create_url.useNavigateToManagementMlLink)('anomaly_detection');
  const {
    validateDatafeedPreview
  } = (0, _kibana.useMlApi)();
  const {
    jobCreator: jc
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [validating, setValidating] = (0, _react.useState)(false);
  const [step, setStep] = (0, _react.useState)(STEP.PICK_DATA_VIEW);
  const [currentDataViewTitle, setCurrentDataViewTitle] = (0, _react.useState)('');
  const [newDataViewTitle, setNewDataViewTitle] = (0, _react.useState)('');
  const [validationResponse, setValidationResponse] = (0, _react.useState)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(function initialPageLoad() {
    setCurrentDataViewTitle(jobCreator.indexPatternTitle);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function stepChange() {
    if (step === STEP.PICK_DATA_VIEW) {
      setValidationResponse(null);
    }
  }, [step]);
  function onDataViewSelected(dataViewId) {
    if (validating === false) {
      setStep(STEP.VALIDATE);
      validate(dataViewId);
    }
  }
  const validate = (0, _react.useCallback)(async dataViewId => {
    setValidating(true);
    const {
      title
    } = await dataViews.get(dataViewId);
    setNewDataViewTitle(title);
    const indices = title.split(',');
    if (jobCreator.detectors.length) {
      const datafeed = {
        ...jobCreator.datafeedConfig,
        indices
      };
      const resp = await validateDatafeedPreview({
        job: {
          ...jobCreator.jobConfig,
          datafeed_config: datafeed
        }
      });
      setValidationResponse(resp);
    }
    setValidating(false);
  }, [dataViews, validateDatafeedPreview, jobCreator]);
  const applyDataView = (0, _react.useCallback)(() => {
    const newIndices = newDataViewTitle.split(',');
    jobCreator.indices = newIndices;
    (0, _general.resetAdvancedJob)(jobCreator, navigateToMlManagementLink);
  }, [jobCreator, newDataViewTitle, navigateToMlManagementLink]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "mlJobMgmtImportJobsFlyout",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step0.title",
    defaultMessage: "Change data view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, step === STEP.PICK_DATA_VIEW && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step1.title",
    defaultMessage: "Select new data view for the job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "mlJobsDatafeedDataView",
    key: "searchSavedObjectFinder",
    onChoose: onDataViewSelected,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.step1.noMatchingError', {
      defaultMessage: 'No matching data views found.'
    }),
    savedObjectMetaData: [{
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.step1.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: fixedPageSize,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  })), step === STEP.VALIDATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step2.title",
    defaultMessage: "Changing {dv1} for {dv2}",
    values: {
      dv1: currentDataViewTitle,
      dv2: newDataViewTitle
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }), validating === true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step2.validatingText",
    defaultMessage: "Checking data view and job compatibility",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(ValidationMessage, {
    validationResponse: validationResponse,
    dataViewTitle: newDataViewTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: setStep.bind(null, STEP.PICK_DATA_VIEW),
    isDisabled: validating,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step2.backButton",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => applyDataView(),
    isDisabled: validating,
    "data-test-subj": "mlJobsImportButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.step2.ApplyButton",
    defaultMessage: "Apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 21
    }
  }))))))));
};
exports.ChangeDataViewModal = ChangeDataViewModal;
const ValidationMessage = ({
  validationResponse,
  dataViewTitle
}) => {
  if (validationResponse === null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.validation.noDetectors.title', {
        defaultMessage: 'Data view valid'
      }),
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.datafeedStep.dataView.validation.noDetectors.message",
      defaultMessage: "No detectors have been configured; this data view can be applied to the job.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 9
      }
    }));
  }
  if (validationResponse.valid === true) {
    if (validationResponse.documentsFound === true) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.validation.valid.title', {
          defaultMessage: 'Data view valid'
        }),
        color: "primary",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.datafeedStep.dataView.validation.valid.message",
        defaultMessage: "This data view can be applied to this job.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 11
        }
      }));
    } else {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.validation.possiblyInvalid.title', {
          defaultMessage: 'Data view possibly invalid'
        }),
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.datafeedStep.dataView.validation.possiblyInvalid.message",
        defaultMessage: "This data view produced no results when previewing the datafeed. There may be no documents in {dataViewTitle}.",
        values: {
          dataViewTitle
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 11
        }
      }));
    }
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.dataView.validation.invalid.title', {
        defaultMessage: 'Data view invalid'
      }),
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.datafeedStep.dataView.validation.invalid.message",
      defaultMessage: "This data view produced an error when attempting to preview the datafeed. The fields selected for this job might not exist in {dataViewTitle}.",
      values: {
        dataViewTitle
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.datafeedStep.dataView.validation.invalid.reason",
      defaultMessage: "Reason:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 9
      }
    }), validationResponse.error ? (0, _mlErrorUtils.extractErrorMessage)(validationResponse.error) : null);
  }
};