"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartsErrorCallOuts = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/explorer_charts_error_callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExplorerChartsErrorCallOuts = ({
  errorMessagesByType
}) => {
  if (!errorMessagesByType || Object.keys(errorMessagesByType).length === 0) return null;
  const content = Object.keys(errorMessagesByType).map(errorType => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: 'warning',
    size: "s",
    key: errorType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorerCharts.errorCallOutMessage",
    defaultMessage: "You can't view anomaly charts for {jobs} because {reason}.",
    values: {
      jobs: [...errorMessagesByType[errorType]].join(', '),
      reason: errorType
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
};
exports.ExplorerChartsErrorCallOuts = ExplorerChartsErrorCallOuts;