"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _public = require("@kbn/presentation-util-plugin/public");
var _select_severity = require("../components/controls/select_severity");
var _anomaly_charts_initializer = require("../../embeddables/anomaly_charts/anomaly_charts_initializer");
var _anomaly_explorer_context = require("./anomaly_explorer_context");
var _string_utils = require("../util/string_utils");
var _use_cases_modal = require("../contexts/kibana/use_cases_modal");
var _anomaly_explorer_charts_service = require("../services/anomaly_explorer_charts_service");
var _embeddables = require("../../embeddables");
var _kibana = require("../contexts/kibana");
var _explorer_utils = require("./explorer_utils");
var _utils = require("../../embeddables/anomaly_charts/utils");
var _constants = require("../../cases/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/anomaly_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
function getDefaultEmbeddablePanelConfig(jobIds, queryString) {
  return {
    id: (0, _eui.htmlIdGenerator)()(),
    title: (0, _utils.getDefaultExplorerChartsPanelTitle)(jobIds).concat(queryString ? `- ${queryString}` : '')
  };
}
const AnomalyContextMenu = ({
  selectedJobs,
  selectedCells,
  bounds,
  interval,
  chartsCount,
  mergedGroupsAndJobsIds
}) => {
  var _capabilities$dashboa, _capabilities$dashboa2, _panels$, _panels$$items;
  const {
    services: {
      application: {
        capabilities
      },
      cases,
      embeddable
    }
  } = (0, _kibana.useMlKibana)();
  const globalTimeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const [isAddDashboardsActive, setIsAddDashboardActive] = (0, _react.useState)(false);
  const [severity] = (0, _select_severity.useTableSeverity)();
  const [maxSeriesToPlot, setMaxSeriesToPlot] = (0, _react.useState)(_anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const closePopoverOnAction = (0, _react.useCallback)(actionCallback => {
    setIsMenuOpen(false);
    actionCallback();
  }, [setIsMenuOpen]);
  const openCasesModal = (0, _use_cases_modal.useCasesModal)(_embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE, _constants.CASES_TOAST_MESSAGES_TITLES.ANOMALY_CHARTS(maxSeriesToPlot));
  const canEditDashboards = (_capabilities$dashboa = (_capabilities$dashboa2 = capabilities.dashboard_v2) === null || _capabilities$dashboa2 === void 0 ? void 0 : _capabilities$dashboa2.createNew) !== null && _capabilities$dashboa !== void 0 ? _capabilities$dashboa : false;
  const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
  const {
    anomalyExplorerCommonStateService,
    chartsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const {
    queryString
  } = (0, _useObservable.default)(anomalyExplorerCommonStateService.filterSettings$, anomalyExplorerCommonStateService.filterSettings);
  const chartsData = (0, _useObservable.default)(chartsStateService.getChartsData$(), chartsStateService.getChartsData());
  const timeRangeToPlot = (0, _react.useMemo)(() => {
    if (chartsData.seriesToPlot.length > 0) {
      return {
        from: (0, _eui.formatDate)(chartsData.seriesToPlot[0].plotEarliest, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        to: (0, _eui.formatDate)(chartsData.seriesToPlot[0].plotLatest, 'MMM D, YYYY @ HH:mm:ss.SSS')
      };
    }
    if (!!selectedCells && interval !== undefined && bounds !== undefined) {
      const {
        earliestMs,
        latestMs
      } = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, bounds);
      return {
        from: (0, _eui.formatDate)(earliestMs, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        to: (0, _eui.formatDate)(latestMs, 'MMM D, YYYY @ HH:mm:ss.SSS'),
        mode: 'absolute'
      };
    }
    return globalTimeRange;
  }, [chartsData.seriesToPlot, globalTimeRange, selectedCells, bounds, interval]);
  const isMaxSeriesToPlotValid = typeof maxSeriesToPlot === 'number' && maxSeriesToPlot >= 1 && maxSeriesToPlot <= _anomaly_charts_initializer.MAX_ANOMALY_CHARTS_ALLOWED;
  const getEmbeddableInput = (0, _react.useCallback)(timeRange => {
    // Respect the query and the influencers selected
    // If no query or filter set, filter out to the lanes the selected cells
    // And if no selected cells, show everything

    const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.viewByFieldName);
    const influencers = selectionInfluencers !== null && selectionInfluencers !== void 0 ? selectionInfluencers : [];
    const config = getDefaultEmbeddablePanelConfig(mergedGroupsAndJobsIds, queryString);
    const queryFromSelectedCells = influencers.map(s => (0, _string_utils.escapeKueryForEmbeddableFieldValuePair)(s.fieldName, s.fieldValue)).join(' or ');

    // When adding anomaly charts to Dashboard, we want to respect the Dashboard's time range
    // so we are not passing the time range here
    return {
      ...config,
      ...(timeRange ? {
        timeRange
      } : {}),
      jobIds: mergedGroupsAndJobsIds,
      maxSeriesToPlot: maxSeriesToPlot !== null && maxSeriesToPlot !== void 0 ? maxSeriesToPlot : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT,
      severityThreshold: severity.val,
      ...((0, _mlIsDefined.isDefined)(queryString) && queryString !== '' || queryFromSelectedCells !== undefined && queryFromSelectedCells !== '' ? {
        query: {
          query: queryString === '' ? queryFromSelectedCells : queryString,
          language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY
        }
      } : {})
    };
  }, [selectedCells, mergedGroupsAndJobsIds, queryString, maxSeriesToPlot, severity.val]);
  const onSaveCallback = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      ...getEmbeddableInput(),
      title: newTitle,
      description: newDescription
    };
    const state = {
      serializedState: {
        rawState: embeddableInput,
        references: []
      },
      type: _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackages('dashboards', {
      state: [state],
      path
    });
  }, [embeddable, getEmbeddableInput]);
  const panels = (0, _react.useMemo)(() => {
    const rootItems = [];
    const menuPanels = [{
      id: 'panelActions',
      items: rootItems
    }];
    const getContent = callback => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: !isMaxSeriesToPlotValid,
      error: !isMaxSeriesToPlotValid ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotError",
        defaultMessage: "Maximum number of series to plot must be between 1 and 50.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 17
        }
      }) : undefined,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.explorer.addToDashboard.anomalyCharts.maxSeriesToPlotLabel",
        defaultMessage: "Maximum number of series to plot",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 15
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      isInvalid: !isMaxSeriesToPlotValid,
      "data-test-subj": "mlAnomalyChartsInitializerMaxSeries",
      id: "selectMaxSeriesToPlot",
      name: "selectMaxSeriesToPlot",
      value: maxSeriesToPlot,
      onChange: e => setMaxSeriesToPlot(parseInt(e.target.value, 10)),
      min: 1,
      max: _anomaly_charts_initializer.MAX_ANOMALY_CHARTS_ALLOWED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      type: 'submit',
      fullWidth: true,
      onClick: callback,
      disabled: !isMaxSeriesToPlotValid,
      "data-test-subj": 'mlAnomalyChartsSubmitAttachment',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.anomalies.submitAttachLabel",
      defaultMessage: "Attach",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 13
      }
    }))));
    if (canEditDashboards) {
      rootItems.push({
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.explorer.addToDashboardLabel",
          defaultMessage: "Add to dashboard",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 268,
            columnNumber: 11
          }
        }),
        panel: 'addToDashboardPanel',
        icon: 'dashboardApp',
        'data-test-subj': 'mlAnomalyAddChartsToDashboardButton'
      });
      menuPanels.push({
        id: 'addToDashboardPanel',
        size: 's',
        title: _i18n.i18n.translate('xpack.ml.explorer.anomalies.addToDashboardLabel', {
          defaultMessage: 'Add to dashboard'
        }),
        content: getContent(closePopoverOnAction.bind(null, setIsAddDashboardActive.bind(null, true)))
      });
    }
    if (!!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create) || !!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.update)) {
      rootItems.push({
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.explorer.attachToCaseLabel",
          defaultMessage: "Add to case",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 293,
            columnNumber: 11
          }
        }),
        icon: 'casesApp',
        panel: 'addToCasePanel',
        'data-test-subj': 'mlAnomalyAttachChartsToCasesButton'
      });
      menuPanels.push({
        id: 'addToCasePanel',
        size: 's',
        title: _i18n.i18n.translate('xpack.ml.explorer.attachToCaseLabel', {
          defaultMessage: 'Add to case'
        }),
        content: getContent(closePopoverOnAction.bind(null, openCasesModal.bind(null, getEmbeddableInput(timeRangeToPlot))))
      });
    }
    return menuPanels;
  }, [getEmbeddableInput, canEditDashboards, casesPrivileges, maxSeriesToPlot, isMaxSeriesToPlotValid, closePopoverOnAction, openCasesModal, timeRangeToPlot]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!((_panels$ = panels[0]) !== null && _panels$ !== void 0 && (_panels$$items = _panels$.items) !== null && _panels$$items !== void 0 && _panels$$items.length) && chartsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto',
      alignSelf: 'baseline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      "aria-label": _i18n.i18n.translate('xpack.ml.explorer.anomalies.actionsAriaLabel', {
        defaultMessage: 'Actions'
      }),
      color: "text",
      display: "base",
      iconType: "boxesHorizontal",
      onClick: setIsMenuOpen.bind(null, !isMenuOpen),
      "data-test-subj": "mlExplorerAnomalyPanelMenu",
      disabled: chartsCount < 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 15
      }
    }),
    isOpen: isMenuOpen,
    closePopover: setIsMenuOpen.bind(null, false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 'panelActions',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }))) : null, isAddDashboardsActive && selectedJobs ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    canSaveByReference: false,
    objectType: _i18n.i18n.translate('xpack.ml.cases.anomalyCharts.displayName', {
      defaultMessage: 'Anomaly charts'
    }),
    documentInfo: {
      title: (0, _utils.getDefaultExplorerChartsPanelTitle)(mergedGroupsAndJobsIds)
    },
    onClose: setIsAddDashboardActive.bind(null, false),
    onSave: onSaveCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 9
    }
  }) : null);
};
exports.AnomalyContextMenu = AnomalyContextMenu;