"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCytoscapeOptions = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _ml_classification_job = _interopRequireDefault(require("./icons/ml_classification_job.svg"));
var _ml_outlier_detection_job = _interopRequireDefault(require("./icons/ml_outlier_detection_job.svg"));
var _ml_regression_job = _interopRequireDefault(require("./icons/ml_regression_job.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAP_SHAPES = {
  ELLIPSE: 'ellipse',
  RECTANGLE: 'rectangle',
  DIAMOND: 'diamond',
  TRIANGLE: 'triangle',
  ROUND_RECTANGLE: 'round-rectangle'
};
function shapeForNode(el) {
  const type = el.data('type');
  switch (type) {
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS:
      return MAP_SHAPES.ELLIPSE;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS_JOB_MISSING:
      return MAP_SHAPES.ELLIPSE;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRANSFORM:
      return MAP_SHAPES.RECTANGLE;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX:
      return MAP_SHAPES.DIAMOND;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRAINED_MODEL:
      return MAP_SHAPES.TRIANGLE;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INGEST_PIPELINE:
      return MAP_SHAPES.ROUND_RECTANGLE;
    default:
      return MAP_SHAPES.ELLIPSE;
  }
}
function iconForNode(el) {
  const type = el.data('analysisType');
  switch (type) {
    case _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION:
      return _ml_outlier_detection_job.default;
    case _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION:
      return _ml_classification_job.default;
    case _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION:
      return _ml_regression_job.default;
    default:
      return undefined;
  }
}
function borderColorForNode(el, euiTheme) {
  if (el.selected()) {
    return euiTheme.colors.primary;
  }
  const type = el.data('type');
  switch (type) {
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS_JOB_MISSING:
      return euiTheme.colors.fullShade;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS:
      return euiTheme.colors.vis.euiColorVis0;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRANSFORM:
      return euiTheme.colors.vis.euiColorVis2;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX:
      return euiTheme.colors.vis.euiColorVis4;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRAINED_MODEL:
      return euiTheme.colors.vis.euiColorVis5;
    case _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INGEST_PIPELINE:
      return euiTheme.colors.vis.euiColorVis8;
    default:
      return euiTheme.colors.mediumShade;
  }
}
const useCytoscapeOptions = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs', {
    unit: 'px'
  }).fontSize;
  return (0, _react.useMemo)(() => ({
    autoungrabify: true,
    boxSelectionEnabled: false,
    maxZoom: 3,
    minZoom: 0.2,
    style: [{
      selector: 'node',
      style: {
        'background-color': el => el.data('isRoot') ? euiTheme.colors.warning : euiTheme.colors.ghost,
        'background-height': '60%',
        'background-width': '60%',
        'border-color': el => borderColorForNode(el, euiTheme),
        'border-style': 'solid',
        // @ts-ignore
        'background-image': el => iconForNode(el),
        'border-width': el => el.selected() ? 4 : 3,
        color: euiTheme.colors.textParagraph,
        'font-family': 'Inter UI, Segoe UI, Helvetica, Arial, sans-serif',
        'font-size': euiFontSizeXS,
        'min-zoomed-font-size': parseInt(euiTheme.size.l, 10),
        label: 'data(label)',
        shape: el => shapeForNode(el),
        'text-background-color': euiTheme.colors.lightestShade,
        'text-background-opacity': 0,
        'text-background-padding': euiTheme.size.xs,
        'text-background-shape': 'roundrectangle',
        'text-margin-y': parseInt(euiTheme.size.s, 10),
        'text-max-width': '200px',
        'text-valign': 'bottom',
        'text-wrap': 'wrap'
      }
    }, {
      selector: 'edge',
      style: {
        'curve-style': 'taxi',
        // @ts-ignore
        'taxi-direction': 'rightward',
        'line-color': euiTheme.colors.lightShade,
        'overlay-opacity': 0,
        'target-arrow-color': euiTheme.colors.lightShade,
        'target-arrow-shape': 'triangle',
        // @ts-ignore
        'target-distance-from-node': euiTheme.size.xs,
        width: 1,
        'source-arrow-shape': 'none'
      }
    }]
  }), [euiFontSizeXS, euiTheme]);
};
exports.useCytoscapeOptions = useCytoscapeOptions;