"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteActionNameText = exports.DeleteActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _common = require("../analytics_list/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_delete/delete_action_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const deleteActionNameText = exports.deleteActionNameText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteActionNameText', {
  defaultMessage: 'Delete'
});
const DeleteActionName = ({
  isDisabled,
  item
}) => {
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _common.isDataFrameAnalyticsRunning)(item.stats.state) ? _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteActionDisabledToolTipContent', {
        defaultMessage: 'Stop the data frame analytics job in order to delete it.'
      }) : (0, _check_capabilities.createPermissionFailureMessage)('canStartStopDataFrameAnalytics'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, deleteActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText);
};
exports.DeleteActionName = DeleteActionName;