"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexData = void 0;
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _new_job_capabilities_service_analytics = require("../../services/new_job_capabilities/new_job_capabilities_service_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexData = async (mlApi, jobConfig, dataGrid, searchQuery, options) => {
  if (jobConfig !== undefined) {
    const newJobCapsServiceAnalytics = (0, _new_job_capabilities_service_analytics.mlJobCapsServiceAnalyticsFactory)(mlApi);
    const {
      pagination,
      setErrorMessage,
      setRowCountInfo,
      setStatus,
      setTableItems,
      sortingColumns
    } = dataGrid;
    setErrorMessage('');
    setStatus(_mlDataGrid.INDEX_STATUS.LOADING);
    try {
      const sort = sortingColumns.map(column => {
        const {
          id
        } = column;
        column.id = newJobCapsServiceAnalytics.isKeywordAndTextType(id) ? `${id}.keyword` : id;
        return column;
      }).reduce((s, column) => {
        s[column.id] = {
          order: column.direction
        };
        return s;
      }, {});
      const {
        pageIndex,
        pageSize
      } = pagination;
      // TODO: remove results_field from `fields` when possible
      const resp = await mlApi.esSearch({
        index: jobConfig.dest.index,
        body: {
          fields: ['*'],
          _source: false,
          query: searchQuery,
          from: pageIndex * pageSize,
          size: pageSize,
          ...(Object.keys(sort).length > 0 ? {
            sort
          } : {})
        }
      });
      if (!options.didCancel) {
        setRowCountInfo({
          rowCount: typeof resp.hits.total === 'number' ? resp.hits.total : resp.hits.total.value,
          rowCountRelation: typeof resp.hits.total === 'number' ? 'eq' : resp.hits.total.relation
        });
        setTableItems(resp.hits.hits.map(d => {
          var _d$fields;
          return (0, _mlDataGrid.getProcessedFields)((_d$fields = d.fields) !== null && _d$fields !== void 0 ? _d$fields : {}, key => key.startsWith(`${jobConfig.dest.results_field}.feature_importance`) || key.startsWith(`${jobConfig.dest.results_field}.feature_influence`));
        }));
        setStatus(_mlDataGrid.INDEX_STATUS.LOADED);
      }
    } catch (e) {
      setErrorMessage((0, _mlErrorUtils.extractErrorMessage)(e));
      setStatus(_mlDataGrid.INDEX_STATUS.ERROR);
    }
  }
};
exports.getIndexData = getIndexData;