"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalAdvancedSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _save_changes_button = require("./save_changes_button");
var _kibana = require("../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_inference/components/additional_advanced_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdditionalAdvancedSettings = exports.AdditionalAdvancedSettings = /*#__PURE__*/(0, _react.memo)(({
  handleAdvancedConfigUpdate,
  condition,
  tag
}) => {
  var _additionalSettings$c, _additionalSettings$t;
  const [additionalSettings, setAdditionalSettings] = (0, _react.useState)(condition || tag ? {
    condition,
    tag
  } : undefined);
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const handleAdditionalSettingsChange = settingsChange => {
    setAdditionalSettings({
      ...additionalSettings,
      ...settingsChange
    });
  };
  const accordionId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const additionalSettingsUpdated = (0, _react.useMemo)(() => (additionalSettings === null || additionalSettings === void 0 ? void 0 : additionalSettings.tag) !== tag || (additionalSettings === null || additionalSettings === void 0 ? void 0 : additionalSettings.condition) !== condition, [additionalSettings, tag, condition]);
  const updateAdditionalSettings = () => {
    handleAdvancedConfigUpdate({
      ...additionalSettings
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "mlTrainedModelsInferenceAdvancedSettingsAccordion",
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "mlTrainedModelsInferenceAdvancedSettingsAccordionButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.additionalSettingsLabel",
      defaultMessage: "Additional settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }, additionalSettingsUpdated ? /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateAdditionalSettings,
      disabled: additionalSettings === undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 17
      }
    }) : null)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.conditionLabel",
      defaultMessage: "Condition (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 19
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.conditionHelpText",
      defaultMessage: "This condition must be written as a {painlessDocs} script. If provided, this inference processor only runs when condition is true.",
      values: {
        painlessDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          target: "_blank",
          href: links.scriptedFields.painlessWalkthrough,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 25
          }
        }, "Painless")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "mlTrainedModelsInferenceAdvancedSettingsConditionTextArea",
    "aria-label": _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.conditionAriaLabel', {
      defaultMessage: 'Optional condition for running the processor'
    }),
    value: (_additionalSettings$c = additionalSettings === null || additionalSettings === void 0 ? void 0 : additionalSettings.condition) !== null && _additionalSettings$c !== void 0 ? _additionalSettings$c : '',
    onChange: e => handleAdditionalSettingsChange({
      condition: e.target.value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.TagLabel",
      defaultMessage: "Tag (optional)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 23
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.tagHelpText",
      defaultMessage: "Identifier for the processor. Useful for debugging and metrics.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "mlTrainedModelsInferenceAdvancedSettingsTagInput",
    value: (_additionalSettings$t = additionalSettings === null || additionalSettings === void 0 ? void 0 : additionalSettings.tag) !== null && _additionalSettings$t !== void 0 ? _additionalSettings$t : '',
    onChange: e => handleAdditionalSettingsChange({
      tag: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.tagAriaLabel', {
      defaultMessage: 'Optional tag identifier for the processor'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 21
    }
  }))))))));
});