"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableSeverity = exports.useDefaultSeverity = exports.getSeverityRangeDisplay = exports.SelectSeverityUI = exports.SelectSeverity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _multi_super_select = require("../../multi_super_select/multi_super_select");
var _use_severity_options = require("../../../explorer/hooks/use_severity_options");
var _severity_format_resolver = require("./severity_format_resolver");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/controls/select_severity/select_severity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering a select element with threshold levels.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * React hook that returns the default table severity state
 */
const useDefaultSeverity = () => {
  const severityOptions = (0, _use_severity_options.useSeverityOptions)();
  return (0, _react.useMemo)(() => ({
    val: severityOptions.map(option => option.threshold)
  }), [severityOptions]);
};

/**
 * React hook that provides table severity url state management
 */
exports.useDefaultSeverity = useDefaultSeverity;
const useTableSeverity = () => {
  const defaultSeverity = useDefaultSeverity();
  const [rawUrlState, setUrlState, urlStateService] = (0, _mlUrlState.usePageUrlState)('mlSelectSeverity', defaultSeverity);
  const resolvedUrlState = (0, _react.useMemo)(() => ({
    val: (0, _severity_format_resolver.resolveSeverityFormat)(rawUrlState.val)
  }), [rawUrlState.val]);
  return [resolvedUrlState, setUrlState, urlStateService];
};

/**
 * Helper function to get severity range display value
 */
exports.useTableSeverity = useTableSeverity;
const getSeverityRangeDisplay = val => {
  switch (val) {
    case _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL:
      return '75-100';
    case _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR:
      return '50-75';
    case _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR:
      return '25-50';
    case _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING:
      return '3-25';
    case _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW:
      return '0-3';
    default:
      return val.toString();
  }
};
exports.getSeverityRangeDisplay = getSeverityRangeDisplay;
const useFormattedSeverityOptions = (selectedSeverities = []) => {
  const severityOptions = (0, _use_severity_options.useSeverityOptions)();
  return (0, _react.useMemo)(() => {
    return severityOptions.map(({
      color,
      val
    }) => {
      return {
        key: val.toString(),
        label: getSeverityRangeDisplay(val),
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: color,
          css: {
            lineHeight: 'inherit'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 103,
            columnNumber: 18
          }
        }),
        checked: selectedSeverities.some(severity => severity.val === val) ? 'on' : undefined
      };
    });
  }, [severityOptions, selectedSeverities]);
};
const SelectSeverity = ({
  classNames
} = {
  classNames: ''
}) => {
  const [severity, setSeverity] = useTableSeverity();
  // Get the selected severities from the state
  const selectedThresholds = severity.val || [];

  // Update the severity state with new selections
  const handleSeverityChange = (0, _react.useCallback)(newSelectedSeverities => {
    // Extract the thresholds from the selected severities
    const newSelectedThresholds = newSelectedSeverities.map(s => s.threshold);
    setSeverity({
      val: newSelectedThresholds
    });
  }, [setSeverity]);
  return /*#__PURE__*/_react.default.createElement(SelectSeverityUI, {
    severity: selectedThresholds,
    onChange: handleSeverityChange,
    classNames: classNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  });
};
exports.SelectSeverity = SelectSeverity;
const SelectSeverityUI = ({
  classNames = '',
  severity,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const allSeverityOptions = (0, _use_severity_options.useSeverityOptions)();
  const selectedSeverities = (0, _react.useMemo)(() => allSeverityOptions.filter(option => severity.some(threshold => threshold.min === option.threshold.min && threshold.max === option.threshold.max)), [allSeverityOptions, severity]);

  // Create a display string for the selected severities
  const inputDisplay = (0, _react.useMemo)(() => {
    if (severity.length === 1) {
      const selectedSeverity = selectedSeverities[0];
      if (selectedSeverity && typeof selectedSeverity.val === 'number') {
        const rangeDisplay = getSeverityRangeDisplay(selectedSeverity.val);
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: selectedSeverity.color,
          css: {
            lineHeight: 'inherit'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 13
          }
        }, rangeDisplay));
      }
    }

    // For multiple selections, show "Multiple" with horizontally overlapping health icons
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "none",
      css: {
        marginRight: euiTheme.size.s,
        position: 'relative'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }, selectedSeverities.map((selectedSeverity, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      css: {
        position: 'relative',
        marginLeft: index > 0 ? '-6px' : '0',
        width: euiTheme.size.s,
        height: euiTheme.size.s,
        borderRadius: euiTheme.border.radius.medium,
        backgroundColor: selectedSeverity.color,
        zIndex: index + 1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.ml.controls.selectSeverity.multiple', {
      defaultMessage: 'Multiple'
    }))));
  }, [euiTheme.border.radius.medium, euiTheme.size.s, selectedSeverities, severity.length]);

  // Get the options for the multi-select component
  const multiSelectOptions = useFormattedSeverityOptions(selectedSeverities);

  // Handle changes from the multi-select component
  const handleOptionsChange = (0, _react.useCallback)(newOptions => {
    // Get the keys of selected options
    const selectedOptionKeys = newOptions.filter(option => option.checked === 'on').map(option => option.key);

    // Prevent deselecting all options - at least one must remain selected
    if (selectedOptionKeys.length === 0) {
      return;
    }

    // Find the corresponding severity options
    const newSelectedSeverities = allSeverityOptions.filter(option => selectedOptionKeys.includes(option.val.toString()));
    onChange(newSelectedSeverities);
  }, [onChange, allSeverityOptions]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'mlAnomalySeverityThresholdControls',
    className: classNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_super_select.MultiSuperSelect, {
    prepend: _i18n.i18n.translate('xpack.ml.explorer.severityThresholdLabel', {
      defaultMessage: 'Anomaly score'
    }),
    inputDisplay: inputDisplay,
    options: multiSelectOptions,
    onOptionsChange: handleOptionsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }));
};
exports.SelectSeverityUI = SelectSeverityUI;