"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _kibana_services = require("./kibana_services");
var _routes = require("./routes");
var _constants = require("../common/constants");
var _load_layer_wizards = require("./classes/layers/wizards/load_layer_wizards");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/render_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function setAppChrome() {
  if (!(0, _kibana_services.getMapsCapabilities)().save) {
    (0, _kibana_services.getCoreChrome)().setBadge({
      text: _i18n.i18n.translate('xpack.maps.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.maps.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save maps'
      }),
      iconType: 'glasses'
    });
  }
  const mapUrl = (0, _kibana_services.getDocLinks)().links.maps.guide;
  (0, _kibana_services.getCoreChrome)().setHelpExtension({
    appName: 'Maps',
    links: [{
      linkType: 'documentation',
      href: `${mapUrl}`
    }, {
      linkType: 'github',
      title: '[Maps]',
      labels: ['Team:Geo']
    }]
  });
}
async function renderApp({
  element,
  history,
  onAppLeave,
  setHeaderActionMenu,
  theme$
}, {
  coreStart,
  AppUsageTracker,
  savedObjectsTagging
}) {
  const stateTransfer = (0, _kibana_services.getEmbeddableService)().getStateTransfer();
  (0, _load_layer_wizards.registerLayerWizards)();
  setAppChrome();
  function renderMapApp(routeProps) {
    const {
      embeddableId,
      originatingApp,
      valueInput,
      originatingPath
    } = stateTransfer.getIncomingEditorState(_constants.APP_ID) || {};
    let mapEmbeddableState;
    if (routeProps.match.params.savedMapId) {
      mapEmbeddableState = {
        savedObjectId: routeProps.match.params.savedMapId
      };
    } else if (valueInput) {
      mapEmbeddableState = valueInput;
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: (0, _kibana_services.getCore)(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_routes.MapPage, {
      mapEmbeddableState: mapEmbeddableState,
      embeddableId: embeddableId,
      onAppLeave: onAppLeave,
      setHeaderActionMenu: setHeaderActionMenu,
      stateTransfer: stateTransfer,
      originatingApp: originatingApp,
      originatingPath: originatingPath,
      history: history,
      key: routeProps.match.params.savedMapId ? routeProps.match.params.savedMapId : 'new',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }));
  }
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, (0, _kibana_services.getCore)(), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(AppUsageTracker, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: coreStart,
    savedObjectsTagging,
    FormattedRelative: _i18nReact.FormattedRelative,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/map/:savedMapId`,
    render: renderMapApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/map`,
    render: renderMapApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }), "// Redirect other routes to list, or if hash-containing, their non-hash equivalents", /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ``,
    render: ({
      location: {
        pathname,
        hash
      }
    }) => {
      if (hash) {
        // Remove leading hash
        const newPath = hash.substr(1);
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: newPath,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 28
          }
        });
      } else if (pathname === '/' || pathname === '') {
        return /*#__PURE__*/_react.default.createElement(_routes.ListPage, {
          history: history,
          stateTransfer: stateTransfer,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 28
          }
        });
      } else {
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 28
          }
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  })))))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
}