"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapRenderer = MapRenderer;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _create_basemap_layer_descriptor = require("../../classes/layers/create_basemap_layer_descriptor");
var _constants = require("../../../common/constants");
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/react_embeddable/map_renderer/map_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getLayers(layerList) {
  const basemapLayer = (0, _create_basemap_layer_descriptor.createBasemapLayerDescriptor)();
  return basemapLayer ? [basemapLayer, ...layerList] : layerList;
}
function MapRenderer(props) {
  const mapApiRef = (0, _react.useRef)(undefined);
  const beforeApiReadyLayerListRef = (0, _react.useRef)(undefined);
  (0, _react.useEffect)(() => {
    if (mapApiRef.current) {
      mapApiRef.current.setLayerList(getLayers(props.layerList));
    } else {
      beforeApiReadyLayerListRef.current = getLayers(props.layerList);
    }
  }, [props.layerList]);
  const searchApi = (0, _presentationPublishing.useSearchApi)({
    filters: props.filters,
    query: props.query,
    timeRange: props.timeRange
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mapEmbeddableContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: _constants.MAP_SAVED_OBJECT_TYPE,
    getParentApi: () => ({
      type: _types.MAP_RENDERER_TYPE,
      getTooltipRenderer: props.getTooltipRenderer,
      hideFilterActions: props.hideFilterActions,
      isSharable: props.isSharable,
      getSerializedStateForChild: () => {
        var _props$title, _props$mapSettings;
        return {
          rawState: {
            attributes: {
              title: (_props$title = props.title) !== null && _props$title !== void 0 ? _props$title : '',
              layers: getLayers(props.layerList)
            },
            hidePanelTitles: !Boolean(props.title),
            isLayerTOCOpen: typeof props.isLayerTOCOpen === 'boolean' ? props.isLayerTOCOpen : false,
            mapCenter: props.mapCenter,
            mapSettings: (_props$mapSettings = props.mapSettings) !== null && _props$mapSettings !== void 0 ? _props$mapSettings : {}
          },
          references: []
        };
      },
      ...searchApi
    }),
    onApiAvailable: api => {
      mapApiRef.current = api;
      if (beforeApiReadyLayerListRef.current) {
        api.setLayerList(beforeApiReadyLayerListRef.current);
      }
      if (props.onApiAvailable) {
        props.onApiAvailable(api);
      }
    },
    hidePanelChrome: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
}