"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractLayerDescriptorParams = extractLayerDescriptorParams;
var _common = require("@kbn/data-views-plugin/common");
var _tile_map_vis_type = require("./tile_map_vis_type");
var _geo_hash = require("./geo_hash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractLayerDescriptorParams(vis) {
  var _vis$data$indexPatter, _vis$data, _vis$data$aggs, _vis$data2, _vis$data2$aggs;
  const params = {
    label: vis.title ? vis.title : _tile_map_vis_type.title,
    mapType: vis.params.mapType,
    colorSchema: vis.params.colorSchema,
    indexPatternId: (_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id,
    metricAgg: 'count'
  };
  const bucketAggs = (_vis$data = vis.data) === null || _vis$data === void 0 ? void 0 : (_vis$data$aggs = _vis$data.aggs) === null || _vis$data$aggs === void 0 ? void 0 : _vis$data$aggs.byType('buckets');
  if (bucketAggs !== null && bucketAggs !== void 0 && bucketAggs.length && bucketAggs[0].type.dslName === _geo_hash.GEOHASH_GRID) {
    var _bucketAggs$0$getFiel;
    params.geoFieldName = (_bucketAggs$0$getFiel = bucketAggs[0].getField()) === null || _bucketAggs$0$getFiel === void 0 ? void 0 : _bucketAggs$0$getFiel.name;
  } else if (vis.data.indexPattern) {
    // attempt to default to first geo point field when geohash is not configured yet
    const geoField = vis.data.indexPattern.fields.find(field => {
      return !(0, _common.isNestedField)(field) && field.aggregatable && field.type === 'geo_point';
    });
    if (geoField) {
      params.geoFieldName = geoField.name;
    }
  }
  const metricAggs = (_vis$data2 = vis.data) === null || _vis$data2 === void 0 ? void 0 : (_vis$data2$aggs = _vis$data2.aggs) === null || _vis$data2$aggs === void 0 ? void 0 : _vis$data2$aggs.byType('metrics');
  if (metricAggs !== null && metricAggs !== void 0 && metricAggs.length) {
    var _metricAggs$0$getFiel;
    params.metricAgg = metricAggs[0].type.dslName;
    params.metricFieldName = (_metricAggs$0$getFiel = metricAggs[0].getField()) === null || _metricAggs$0$getFiel === void 0 ? void 0 : _metricAggs$0$getFiel.name;
  }
  return params;
}