"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _constants = require("../../../../common/constants");
var _tooltip_popover = require("./tooltip_popover");
var _vector_layer = require("../../../classes/layers/vector_layer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/tooltip_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function justifyAnchorLocation(mbLngLat, targetFeature) {
  let popupAnchorLocation = [mbLngLat.lng, mbLngLat.lat]; // default popup location to mouse location
  if (targetFeature.geometry.type === 'Point') {
    const coordinates = targetFeature.geometry.coordinates.slice();

    // Ensure that if the map is zoomed out such that multiple
    // copies of the feature are visible, the popup appears
    // over the copy being pointed to.
    while (Math.abs(mbLngLat.lng - coordinates[_constants.LON_INDEX]) > 180) {
      coordinates[0] += mbLngLat.lng > coordinates[_constants.LON_INDEX] ? 360 : -360;
    }
    popupAnchorLocation = coordinates;
  }
  return popupAnchorLocation;
}
class TooltipControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMapRemoved", false);
    (0, _defineProperty2.default)(this, "_setIsMapRemoved", () => {
      this._isMapRemoved = true;
    });
    (0, _defineProperty2.default)(this, "_onSourceData", e => {
      if (e.sourceId && e.sourceId !== _constants.SPATIAL_FILTERS_LAYER_ID && e.dataType === 'source' && (e.source.type === 'vector' || e.source.type === 'geojson')) {
        // map features changed, update tooltip state to match new map state.
        this._updateOpentooltips();
      }
    });
    (0, _defineProperty2.default)(this, "_updateOpentooltips", _lodash.default.debounce(() => {
      if (this.props.openTooltips.length === 0) {
        return;
      }
      const openTooltips = this.props.openTooltips.map(tooltipState => {
        const mbFeatures = this._getMbFeaturesUnderPointer(this.props.mbMap.project(tooltipState.location));
        return {
          ...tooltipState,
          features: this._getTooltipFeatures(mbFeatures, tooltipState.isLocked, tooltipState.id)
        };
      }).filter(tooltipState => {
        return tooltipState.features.length > 0;
      });
      this.props.updateOpenTooltips(openTooltips);
    }, 300));
    (0, _defineProperty2.default)(this, "_onMouseout", () => {
      this._updateHoverTooltipState.cancel();
      if (!this.props.hasLockedTooltips) {
        this.props.closeOnHoverTooltip();
      }
    });
    (0, _defineProperty2.default)(this, "_findLayerById", layerId => {
      return this.props.layerList.find(layer => {
        return layer.getId() === layerId && (0, _vector_layer.isVectorLayer)(layer);
      });
    });
    // Must load original geometry instead of using geometry from mapbox feature.
    // Mapbox feature geometry is from vector tile and is not the same as the original geometry.
    (0, _defineProperty2.default)(this, "_getFeatureGeometry", ({
      layerId,
      featureId
    }) => {
      const tooltipLayer = this._findLayerById(layerId);
      if (!tooltipLayer || featureId === undefined) {
        return null;
      }
      const targetFeature = tooltipLayer.getFeatureById(featureId);
      if (!targetFeature) {
        return null;
      }
      return targetFeature.geometry;
    });
    (0, _defineProperty2.default)(this, "_lockTooltip", e => {
      if (this.props.filterModeActive || this.props.drawModeActive) {
        // ignore click events when in draw mode
        return;
      }
      this._updateHoverTooltipState.cancel(); // ignore any possible moves

      const mbFeatures = this._getMbFeaturesUnderPointer(e.point);
      if (!mbFeatures.length) {
        // No features at click location so there is no tooltip to open
        return;
      }
      const targetMbFeataure = mbFeatures[0];
      const popupAnchorLocation = justifyAnchorLocation(e.lngLat, targetMbFeataure);
      const isLocked = true;
      const tooltipId = (0, _uuid.v4)();
      const features = this._getTooltipFeatures(mbFeatures, isLocked, tooltipId);
      if (features.length === 0) {
        return;
      }
      this.props.openOnClickTooltip({
        features,
        location: popupAnchorLocation,
        isLocked,
        id: tooltipId
      });
    });
    (0, _defineProperty2.default)(this, "_updateHoverTooltipState", _lodash.default.debounce(e => {
      if (this._isMapRemoved) {
        // ignore debounced events after mbMap.remove is called.
        return;
      }
      if (this.props.filterModeActive || this.props.hasLockedTooltips || this.props.drawModeActive) {
        // ignore hover events when in draw mode or when there are locked tooltips
        return;
      }
      const mbFeatures = this._getMbFeaturesUnderPointer(e.point);
      if (!mbFeatures.length) {
        this.props.closeOnHoverTooltip();
        return;
      }
      const targetMbFeature = mbFeatures[0];
      const layer = this._getLayerByMbLayerId(targetMbFeature.layer.id);
      if (layer && this.props.openTooltips[0] && this.props.openTooltips[0].features.length) {
        const firstFeature = this.props.openTooltips[0].features[0];
        if (layer.getFeatureId(targetMbFeature) === firstFeature.id) {
          // ignore hover events when hover tooltip is all ready opened for feature
          return;
        }
      }
      const popupAnchorLocation = justifyAnchorLocation(e.lngLat, targetMbFeature);
      const isLocked = false;
      const tooltipId = (0, _uuid.v4)();
      const features = this._getTooltipFeatures(mbFeatures, isLocked, tooltipId);
      if (features.length === 0) {
        return;
      }
      this.props.openOnHoverTooltip({
        features,
        location: popupAnchorLocation,
        isLocked,
        id: tooltipId
      });
    }, 100));
  }
  componentDidMount() {
    this.props.mbMap.on('mouseout', this._onMouseout);
    this.props.mbMap.on('mousemove', this._updateHoverTooltipState);
    this.props.mbMap.on('click', this._lockTooltip);
    this.props.mbMap.on('remove', this._setIsMapRemoved);
    this.props.mbMap.on('sourcedata', this._onSourceData);
  }
  componentWillUnmount() {
    this.props.mbMap.off('mouseout', this._onMouseout);
    this.props.mbMap.off('mousemove', this._updateHoverTooltipState);
    this.props.mbMap.off('click', this._lockTooltip);
    this.props.mbMap.off('remove', this._setIsMapRemoved);
    this.props.mbMap.off('sourcedata', this._onSourceData);
  }
  _getLayerByMbLayerId(mbLayerId) {
    return this.props.layerList.find(layer => {
      const mbLayerIds = layer.getMbLayerIds();
      return (0, _vector_layer.isVectorLayer)(layer) && mbLayerIds.indexOf(mbLayerId) > -1;
    });
  }
  _getTooltipFeatures(mbFeatures, isLocked, tooltipId) {
    const uniqueFeatures = [];
    // there may be duplicates in the results from mapbox
    // this is because mapbox returns the results per tile
    // for polygons or lines, it might return multiple features, one for each tile
    for (let i = 0; i < mbFeatures.length; i++) {
      const mbFeature = mbFeatures[i];
      const layer = this._getLayerByMbLayerId(mbFeature.layer.id);
      if (!layer || !layer.canShowTooltip() || layer.areTooltipsDisabled()) {
        continue;
      }

      // masking must use paint property "opacity" to hide features in order to support feature state
      // therefore, there is no way to remove masked features with queryRenderedFeatures
      // masked features must be removed via manual filtering
      const masks = layer.getMasks();
      const maskHiddingFeature = masks.find(mask => mask.isFeatureMasked(mbFeature));
      if (maskHiddingFeature) {
        continue;
      }
      const featureId = layer.getFeatureId(mbFeature);
      if (featureId === undefined) {
        continue;
      }
      const layerId = layer.getId();
      let match = false;
      for (let j = 0; j < uniqueFeatures.length; j++) {
        const uniqueFeature = uniqueFeatures[j];
        if (featureId === uniqueFeature.id && layerId === uniqueFeature.layerId) {
          match = true;
          continue;
        }
      }
      if (!match) {
        const mbProperties = {
          ...(mbFeature.properties ? mbFeature.properties : {}),
          ...(mbFeature.state ? mbFeature.state : {})
        };
        const actions = isLocked ? layer.getSource().getFeatureActions({
          addFilters: this.props.addFilters,
          featureId: featureId + '',
          geoFieldNames: this.props.geoFieldNames,
          getFilterActions: this.props.getFilterActions,
          getActionContext: this.props.getActionContext,
          getGeojsonGeometry: () => {
            const geojsonFeature = layer.getFeatureById(featureId);
            return geojsonFeature ? geojsonFeature.geometry : null;
          },
          mbFeature,
          onClose: () => {
            this.props.closeOnClickTooltip(tooltipId);
          }
        }) : [];
        const hasActions = isLocked && actions.length;
        if (hasActions || layer.canShowTooltip()) {
          // This keeps track of first feature (assuming these will be identical for features in different tiles)
          uniqueFeatures.push({
            id: featureId,
            layerId,
            mbProperties,
            actions
          });
        }
      }
    }
    return uniqueFeatures;
  }
  _getMbLayerIdsForTooltips() {
    const mbLayerIds = this.props.layerList.reduce((accumulator, layer) => {
      // tooltips are only supported for vector layers, filter out all other layer types
      return layer.isVisible() && (0, _vector_layer.isVectorLayer)(layer) ? accumulator.concat(layer.getMbTooltipLayerIds()) : accumulator;
    }, []);

    // Ensure that all layers are actually on the map.
    // The raw list may contain layer-ids that have not been added to the map yet.
    // For example:
    // a vector or heatmap layer will not add a source and layer to the mapbox-map, until that data is available.
    // during that data-fetch window, the app should not query for layers that do not exist.
    return mbLayerIds.filter(mbLayerId => {
      return !!this.props.mbMap.getLayer(mbLayerId);
    });
  }
  _getMbFeaturesUnderPointer(mbLngLatPoint) {
    if (!this.props.mbMap) {
      return [];
    }
    const mbLayerIds = this._getMbLayerIdsForTooltips();
    const PADDING = 2; // in pixels
    const mbBbox = [{
      x: mbLngLatPoint.x - PADDING,
      y: mbLngLatPoint.y - PADDING
    }, {
      x: mbLngLatPoint.x + PADDING,
      y: mbLngLatPoint.y + PADDING
    }];
    return this.props.mbMap.queryRenderedFeatures(mbBbox, {
      layers: mbLayerIds
    });
  }
  render() {
    if (this.props.openTooltips.length === 0) {
      return null;
    }
    return this.props.openTooltips.map(({
      features,
      location,
      id,
      isLocked
    }, index) => {
      const closeTooltip = isLocked ? () => {
        this.props.closeOnClickTooltip(id);
      } : this.props.closeOnHoverTooltip;
      return /*#__PURE__*/_react.default.createElement(_tooltip_popover.TooltipPopover, {
        key: id,
        mbMap: this.props.mbMap,
        findLayerById: this._findLayerById,
        addFilters: this.props.addFilters,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        onSingleValueTrigger: this.props.onSingleValueTrigger,
        renderTooltipContent: this.props.renderTooltipContent,
        features: features,
        location: location,
        closeTooltip: closeTooltip,
        isLocked: isLocked,
        index: index,
        loadFeatureGeometry: this._getFeatureGeometry,
        executionContext: this.props.executionContext,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 377,
          columnNumber: 9
        }
      });
    });
  }
}
exports.TooltipControl = TooltipControl;