"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeaturesTooltip = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _context_menu_panel = require("@elastic/eui/lib/components/context_menu/context_menu_panel.styles");
var _i18n = require("@kbn/i18n");
var _feature_properties = require("./feature_properties");
var _footer = require("./footer");
var _header = require("./header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/features_tooltip/features_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore file exists, but ts def doesn't
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PROPERTIES_VIEW = 'PROPERTIES_VIEW';
const FILTER_ACTIONS_VIEW = 'FILTER_ACTIONS_VIEW';
class FeaturesTooltip extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      currentFeature: null,
      filterView: null,
      prevFeatures: [],
      view: PROPERTIES_VIEW
    });
    (0, _defineProperty2.default)(this, "_setCurrentFeature", feature => {
      this.setState({
        currentFeature: feature
      });
    });
    (0, _defineProperty2.default)(this, "_showPropertiesView", () => {
      this.setState({
        view: PROPERTIES_VIEW,
        filterView: null
      });
    });
    (0, _defineProperty2.default)(this, "_showFilterActionsView", filterView => {
      this.setState({
        view: FILTER_ACTIONS_VIEW,
        filterView
      });
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.features !== prevState.prevFeatures) {
      let nextCurrentFeature = nextProps.features ? nextProps.features[0] : null;
      if (prevState.currentFeature) {
        const updatedCurrentFeature = nextProps.features.find(tooltipFeature => {
          return tooltipFeature.id === prevState.currentFeature.id && tooltipFeature.layerId === prevState.currentFeature.layerId;
        });
        if (updatedCurrentFeature) {
          nextCurrentFeature = updatedCurrentFeature;
        }
      }
      return {
        currentFeature: nextCurrentFeature,
        view: PROPERTIES_VIEW,
        prevFeatures: nextProps.features
      };
    }
    return null;
  }
  _renderActions() {
    if (!this.props.isLocked || !this.state.currentFeature || this.state.currentFeature.actions.length === 0) {
      return null;
    }
    return this.state.currentFeature.actions.map(action => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        css: componentStyles.actionLinksStyles,
        onClick: () => {
          if (action.onClick) {
            action.onClick();
          } else if (action.form) {
            this.setState({
              view: action.id
            });
          }
        },
        key: action.id,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 9
        }
      }, action.label);
    });
  }
  _renderBackButton(label) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      css: [componentStyles.mapFeatureTooltipBackButtonStyles, euiTheme => (0, _context_menu_panel.euiContextMenuPanelStyles)(euiTheme).euiContextMenuPanel__title],
      onClick: this._showPropertiesView,
      icon: "arrowLeft",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    }, label);
  }
  render() {
    if (!this.state.currentFeature) {
      return null;
    }
    const action = this.state.currentFeature.actions.find(({
      id
    }) => {
      return id === this.state.view;
    });
    if (action && action.form) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 9
        }
      }, this._renderBackButton(action.label), action.form);
    }
    if (this.state.view === FILTER_ACTIONS_VIEW) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 9
        }
      }, this._renderBackButton(_i18n.i18n.translate('xpack.maps.tooltip.showAddFilterActionsViewLabel', {
        defaultMessage: 'Filter actions'
      })), this.state.filterView);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_header.Header, {
      key: this.state.currentFeature.layerId,
      layerId: this.state.currentFeature.layerId,
      findLayerById: this.props.findLayerById,
      isLocked: this.props.isLocked,
      onClose: this.props.closeTooltip,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_feature_properties.FeatureProperties, {
      featureId: this.state.currentFeature.id,
      layerId: this.state.currentFeature.layerId,
      mbProperties: this.state.currentFeature.mbProperties,
      loadFeatureProperties: this.props.loadFeatureProperties,
      showFilterButtons: !!this.props.addFilters && this.props.isLocked,
      onCloseTooltip: this.props.closeTooltip,
      addFilters: this.props.addFilters,
      getFilterActions: this.props.getFilterActions,
      getActionContext: this.props.getActionContext,
      onSingleValueTrigger: this.props.onSingleValueTrigger,
      showFilterActions: this._showFilterActionsView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 9
      }
    }), this._renderActions(), /*#__PURE__*/_react.default.createElement(_footer.Footer, {
      features: this.props.features,
      isLocked: this.props.isLocked,
      findLayerById: this.props.findLayerById,
      setCurrentFeature: this._setCurrentFeature,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    }));
  }
}
exports.FeaturesTooltip = FeaturesTooltip;
const componentStyles = {
  actionLinksStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.xs
  }),
  mapFeatureTooltipBackButtonStyles: (0, _react2.css)({
    paddingLeft: '0'
  })
};