"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureGeometryFilterForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
var _geometry_filter_form = require("../../../../components/draw_forms/geometry_filter_form/geometry_filter_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/features_tooltip/feature_geometry_filter_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// over estimated and imprecise value to ensure filter has additional room for any meta keys added when filter is mapped.
const META_OVERHEAD = 100;
class FeatureGeometryFilterForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false,
      errorMsg: undefined
    });
    (0, _defineProperty2.default)(this, "_loadPreIndexedShape", async () => {
      if (!this.props.loadPreIndexedShape) {
        return null;
      }
      this.setState({
        isLoading: true
      });
      let preIndexedShape;
      try {
        preIndexedShape = await this.props.loadPreIndexedShape();
      } catch (err) {
        // ignore error, just fall back to using geometry if preIndexedShape can not be fetched
      }
      if (this._isMounted) {
        this.setState({
          isLoading: false
        });
      }
      return preIndexedShape;
    });
    (0, _defineProperty2.default)(this, "_createFilter", async ({
      geometryLabel,
      relation
    }) => {
      this.setState({
        errorMsg: undefined
      });
      const preIndexedShape = await this._loadPreIndexedShape();
      if (!this._isMounted) {
        // do not create filter if component is unmounted
        return;
      }
      const filter = (0, _elasticsearch_util.buildGeoShapeFilter)({
        preIndexedShape,
        geometry: this.props.geometry,
        geometryLabel,
        geoFieldNames: this.props.geoFieldNames,
        relation
      });

      // Ensure filter will not overflow URL. Filters that contain geometry can be extremely large.
      // No elasticsearch support for pre-indexed shapes and geo_point spatial queries.
      if (window.location.href.length + _rison.default.encode(filter).length + META_OVERHEAD > _public.URL_MAX_LENGTH) {
        this.setState({
          errorMsg: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.filterTooLargeMessage', {
            defaultMessage: 'Cannot create filter. Filters are added to the URL, and this shape has too many vertices to fit in the URL.'
          })
        });
        return;
      }
      this.props.addFilters([filter], _public2.ACTION_GLOBAL_APPLY_FILTER);
      this.props.onClose();
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
      buttonLabel: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.createFilterButtonLabel', {
        defaultMessage: 'Create filter'
      }),
      getFilterActions: this.props.getFilterActions,
      getActionContext: this.props.getActionContext,
      intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.initialGeometryLabel', {
        defaultMessage: 'feature'
      }),
      onSubmit: this._createFilter,
      isLoading: this.state.isLoading,
      errorMsg: this.state.errorMsg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    });
  }
}
exports.FeatureGeometryFilterForm = FeatureGeometryFilterForm;