"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawTooltip = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/draw_control/draw_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const noop = () => {};
class DrawTooltip extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_popoverRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      x: undefined,
      y: undefined,
      isOpen: false
    });
    (0, _defineProperty2.default)(this, "_hideTooltip", () => {
      this._updateTooltipLocation.cancel();
      this.setState({
        isOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_updateTooltipLocation", _lodash.default.throttle(({
      lngLat
    }) => {
      const mouseLocation = this.props.mbMap.project(lngLat);
      if (!this._isMounted) {
        return;
      }
      this.setState({
        isOpen: true,
        x: mouseLocation.x,
        y: mouseLocation.y
      });
    }, 100));
  }
  componentDidMount() {
    this._isMounted = true;
    this.props.mbMap.on('mousemove', this._updateTooltipLocation);
    this.props.mbMap.on('mouseout', this._hideTooltip);
  }
  componentDidUpdate() {
    if (this._popoverRef.current) {
      this._popoverRef.current.positionPopoverFluid();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.mbMap.off('mousemove', this._updateTooltipLocation);
    this.props.mbMap.off('mouseout', this._hideTooltip);
    this._updateTooltipLocation.cancel();
  }
  render() {
    if (this.state.x === undefined || this.state.y === undefined) {
      return null;
    }
    let instructions;
    if (this.props.drawShape === _constants.DRAW_SHAPE.BOUNDS) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.boundsInstructions', {
        defaultMessage: 'Click to start rectangle. Move mouse to adjust rectangle size. Click again to finish.'
      });
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.DISTANCE) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.distanceInstructions', {
        defaultMessage: 'Click to set point. Move mouse to adjust distance. Click to finish.'
      });
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.POLYGON) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.polygonInstructions', {
        defaultMessage: 'Click to start shape. Click to add vertex. Double click to finish.'
      });
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.LINE) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.lineInstructions', {
        defaultMessage: 'Click to start line. Click to add vertex. Double click to finish.'
      });
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.POINT) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.pointInstructions', {
        defaultMessage: 'Click to create point.'
      });
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.DELETE) {
      instructions = _i18n.i18n.translate('xpack.maps.drawTooltip.deleteInstructions', {
        defaultMessage: 'Click feature to delete.'
      });
    } else {
      // unknown draw type, tooltip not needed
      return null;
    }
    const tooltipAnchor = /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '26px',
        width: '26px',
        background: 'transparent'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "drawInstructionsTooltip",
      button: tooltipAnchor,
      anchorPosition: "rightCenter",
      isOpen: this.state.isOpen,
      closePopover: noop,
      ref: this._popoverRef,
      style: {
        pointerEvents: 'none',
        transform: `translate(${this.state.x - 13}px, ${this.state.y - 13}px)`
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, instructions));
  }
}
exports.DrawTooltip = DrawTooltip;