"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsEditor = void 0;
exports.isMetricValid = isMetricValid;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _metric_editor = require("./metric_editor");
var _es_agg_source = require("../../classes/sources/es_agg_source");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/metrics_editor/metrics_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isMetricValid(aggDescriptor) {
  return aggDescriptor.type === _constants.AGG_TYPE.COUNT ? true : aggDescriptor.field !== undefined;
}
class MetricsEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_addMetric", () => {
      this.setState({
        metrics: [...this.state.metrics, {
          type: _constants.AGG_TYPE.COUNT
        }]
      }, this._onSubmit);
    });
    this.state = {
      // There was a bug in 7.8 that initialized metrics to [].
      // This check is needed to handle any saved objects created before the bug was patched.
      metrics: this.props.metrics.length === 0 ? [_es_agg_source.DEFAULT_METRIC] : this.props.metrics
    };
  }
  _onSubmit() {
    const hasInvalidMetric = this.state.metrics.some(metric => {
      return !isMetricValid(metric);
    });
    if (!hasInvalidMetric) {
      this.props.onChange(this.state.metrics);
    }
  }
  _renderMetrics() {
    return this.state.metrics.map((metric, index) => {
      const onMetricChange = updatedMetric => {
        this.setState({
          metrics: [...this.state.metrics.slice(0, index), updatedMetric, ...this.state.metrics.slice(index + 1)]
        }, this._onSubmit);
      };
      const onRemove = () => {
        this.setState({
          metrics: [...this.state.metrics.slice(0, index), ...this.state.metrics.slice(index + 1)]
        }, this._onSubmit);
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        key: index,
        className: "mapMetricEditorPanel__metricEditor",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_metric_editor.MetricEditor, {
        bucketsName: this.props.bucketsName,
        isJoin: this.props.isJoin,
        onChange: onMetricChange,
        metric: metric,
        fields: this.props.fields,
        metricsFilter: this.props.metricsFilter,
        showRemoveButton: index > 0,
        onRemove: onRemove,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }));
    });
  }
  _renderAddMetricButton() {
    if (!this.props.allowMultipleMetrics) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this._addMetric,
      size: "xs",
      iconType: "plusInCircleFilled",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.metricsEditor.addMetricButtonLabel",
      defaultMessage: "Add metric",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapMapLayerPanel__metrics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, this._renderMetrics()), this._renderAddMetricButton());
  }
}
exports.MetricsEditor = MetricsEditor;