"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconPreview = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _mapboxGl = require("@kbn/mapbox-gl");
var _i18n = require("@kbn/i18n");
var _symbol_utils = require("../../symbol_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/icon_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const iconPreviewStyles = (0, _react2.css)({
  height: '150px'
});
class IconPreview extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_containerRef", null);
    (0, _defineProperty2.default)(this, "state", {
      map: null,
      iconColor: '#E7664C'
    });
    (0, _defineProperty2.default)(this, "_setIconColor", iconColor => {
      this.setState({
        iconColor
      }, () => {
        this._syncPaintPropertiesToMap();
      });
    });
    (0, _defineProperty2.default)(this, "_setContainerRef", element => {
      this._containerRef = element;
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._initializeMap();
  }
  componentDidUpdate(prevProps) {
    if (this.props.svg !== prevProps.svg || this.props.cutoff !== prevProps.cutoff || this.props.radius !== prevProps.radius) {
      this._syncImageToMap();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    if (this.state.map) {
      this.state.map.remove();
      this.state.map = null;
    }
  }
  async _syncImageToMap() {
    if (this._isMounted && this.state.map) {
      const map = this.state.map;
      const {
        svg,
        cutoff,
        radius,
        isSvgInvalid
      } = this.props;
      if (!svg || isSvgInvalid) {
        map.setLayoutProperty('icon-layer', 'visibility', 'none');
        return;
      }
      const imageData = await (0, _symbol_utils.createSdfIcon)({
        svg,
        cutoff,
        radius
      });
      if (imageData) {
        if (map.hasImage(IconPreview.iconId)) {
          map.updateImage(IconPreview.iconId, imageData);
        } else {
          map.addImage(IconPreview.iconId, imageData, {
            sdf: true,
            pixelRatio: _symbol_utils.CUSTOM_ICON_PIXEL_RATIO
          });
        }
      }
      map.setLayoutProperty('icon-layer', 'icon-image', IconPreview.iconId);
      map.setLayoutProperty('icon-layer', 'icon-size', 6);
      map.setLayoutProperty('icon-layer', 'visibility', 'visible');
      this._syncPaintPropertiesToMap();
    }
  }
  _syncPaintPropertiesToMap() {
    const {
      map,
      iconColor
    } = this.state;
    if (!map) return;
    map.setPaintProperty('icon-layer', 'icon-halo-color', '#000000');
    map.setPaintProperty('icon-layer', 'icon-halo-width', 1);
    map.setPaintProperty('icon-layer', 'icon-color', iconColor);
    map.setLayoutProperty('icon-layer', 'icon-size', 12);
  }
  _createMapInstance() {
    const map = new _mapboxGl.maplibregl.Map({
      container: this._containerRef,
      interactive: false,
      center: [0, 0],
      zoom: 2,
      style: {
        version: 8,
        name: 'Empty',
        sources: {},
        layers: [{
          id: 'background',
          type: 'background',
          paint: {
            'background-color': 'rgba(0,0,0,0)'
          }
        }]
      }
    });
    map.on('load', () => {
      map.addLayer({
        id: 'icon-layer',
        type: 'symbol',
        source: {
          type: 'geojson',
          data: {
            type: 'Feature',
            geometry: {
              type: 'Point',
              coordinates: [0, 0]
            },
            properties: {}
          }
        }
      });
      this._syncImageToMap();
    });
    return map;
  }
  _initializeMap() {
    const map = this._createMapInstance();
    this.setState({
      map
    });
  }
  render() {
    const iconColor = this.state.iconColor;
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      hasBorder: true,
      hasShadow: false,
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.maps.customIconModal.elementPreviewTooltip', {
        defaultMessage: 'Dynamic styling requires rendering SVG icons using a signed distance function. As a result, sharp corners and intricate details may not render correctly. You may be able to tweak the Alpha threshold and Radius for better results.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.elementPreviewTitle', {
      defaultMessage: 'Render preview'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 21
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      id: "mapsCustomIconPreview__mapContainer",
      ref: this._setContainerRef,
      "data-test-subj": "mapsCustomIconPreview",
      css: iconPreviewStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: "Preview color",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      onChange: this._setIconColor,
      color: iconColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 15
      }
    })))));
  }
}
exports.IconPreview = IconPreview;
(0, _defineProperty2.default)(IconPreview, "iconId", `iconPreview`);