"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLayerWizardConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _apmDataView = require("@kbn/apm-data-view");
var _constants = require("../../../../../../common/constants");
var _observability_layer_template = require("./observability_layer_template");
var _kibana_services = require("../../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/observability/observability_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ObservabilityLayerWizardConfig = exports.ObservabilityLayerWizardConfig = {
  id: _constants.WIZARD_ID.OBSERVABILITY,
  order: 20,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH, _constants.LAYER_WIZARD_CATEGORY.SOLUTIONS],
  getIsDisabled: async () => {
    try {
      await (0, _kibana_services.getIndexPatternService)().get((0, _apmDataView.getStaticDataViewId)((0, _kibana_services.getSpaceId)()));
      return false;
    } catch (e) {
      return true;
    }
  },
  disabledReason: _i18n.i18n.translate('xpack.maps.observability.disabledDesc', {
    defaultMessage: 'Cannot find APM data view. To get started with Observably, go to Observability > Overview.'
  }),
  description: _i18n.i18n.translate('xpack.maps.observability.desc', {
    defaultMessage: 'APM layers'
  }),
  icon: 'logoObservability',
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_observability_layer_template.ObservabilityLayerTemplate, (0, _extends2.default)({}, renderWizardArguments, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    }));
  },
  title: _i18n.i18n.translate('xpack.maps.observability.title', {
    defaultMessage: 'Observability'
  })
};