"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSavedObject = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../common");
var _mapping = require("./mapping");
var _model_versions = require("./model_versions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSavedObject = (savedObjects, logger) => {
  savedObjects.registerType({
    name: _common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'multiple-isolated',
    mappings: _mapping.maintenanceWindowMappings,
    modelVersions: _model_versions.maintenanceWindowModelVersions
  });
};
exports.registerSavedObject = registerSavedObject;