"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateStartDate = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateStartDate = date => {
  const parsedValue = Date.parse(date);
  if (isNaN(parsedValue)) {
    return `Invalid schedule start date: ${date}`;
  }
  if (!_constants.ISO_DATE_REGEX.test(date)) {
    return `Invalid schedule start date format: ${date}. Use ISO 8601 YYYY-MM-DDTHH:mm:ss.sssZ`;
  }
  return;
};
exports.validateStartDate = validateStartDate;