"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformInternalMaintenanceWindowToExternal = void 0;
var _schedule = require("../../../../../../schemas/schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  This function converts from the internal Maintenance Window type used by the application client,
 *  to the external human readable type used by the public APIs.
 */
const transformInternalMaintenanceWindowToExternal = maintenanceWindow => {
  var _maintenanceWindow$sc;
  const kql = (_maintenanceWindow$sc = maintenanceWindow.scopedQuery) === null || _maintenanceWindow$sc === void 0 ? void 0 : _maintenanceWindow$sc.kql;
  const custom = (0, _schedule.transformRRuleToCustomScheduleV1)({
    duration: maintenanceWindow.duration,
    rRule: maintenanceWindow.rRule
  });
  return {
    id: maintenanceWindow.id,
    title: maintenanceWindow.title,
    enabled: maintenanceWindow.enabled,
    schedule: {
      custom
    },
    created_by: maintenanceWindow.createdBy,
    updated_by: maintenanceWindow.updatedBy,
    created_at: maintenanceWindow.createdAt,
    updated_at: maintenanceWindow.updatedAt,
    status: maintenanceWindow.status,
    ...(kql && {
      scope: {
        alerting: {
          query: {
            kql
          }
        }
      }
    })
  };
};
exports.transformInternalMaintenanceWindowToExternal = transformInternalMaintenanceWindowToExternal;