"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseState = void 0;
exports.verifyApiAccessFactory = verifyApiAccessFactory;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LicenseState {
  constructor(license$) {
    (0, _defineProperty2.default)(this, "licenseInformation", this.checkLicense(undefined));
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "license", void 0);
    this.subscription = license$.subscribe(this.updateInformation.bind(this));
  }
  updateInformation(license) {
    this.license = license;
    this.licenseInformation = this.checkLicense(license);
  }
  clean() {
    this.subscription.unsubscribe();
  }
  getLicenseInformation() {
    return this.licenseInformation;
  }
  getIsSecurityEnabled() {
    var _this$license;
    if (!this.license || !((_this$license = this.license) !== null && _this$license !== void 0 && _this$license.isAvailable)) {
      return null;
    }
    const {
      isEnabled
    } = this.license.getFeature('security');
    return isEnabled;
  }
  checkLicense(license) {
    if (!license || !license.isAvailable) {
      return {
        showAppLink: true,
        enableAppLink: false,
        message: _i18n.i18n.translate('xpack.maintenanceWindows.serverSideErrors.unavailableLicenseInformationErrorMessage', {
          defaultMessage: 'Maintenance Windows is unavailable - license information is not available at this time.'
        })
      };
    }
    const check = license.check(_constants.PLUGIN.ID, _constants.PLUGIN.MINIMUM_LICENSE_REQUIRED);
    switch (check.state) {
      case 'expired':
        return {
          showAppLink: true,
          enableAppLink: false,
          message: check.message || ''
        };
      case 'invalid':
      case 'unavailable':
        return {
          showAppLink: false,
          enableAppLink: false,
          message: check.message || ''
        };
      case 'valid':
        return {
          showAppLink: true,
          enableAppLink: true,
          message: ''
        };
      default:
        return (0, _std.assertNever)(check.state);
    }
  }
  ensureLicenseForMaintenanceWindow() {
    var _this$license2;
    if (!this.license || !((_this$license2 = this.license) !== null && _this$license2 !== void 0 && _this$license2.isAvailable)) {
      throw _boom.default.forbidden(_i18n.i18n.translate('xpack.maintenanceWindows.serverSideErrors.maintenanceWindow.unavailableLicenseErrorMessage', {
        defaultMessage: 'Maintenance window is disabled because license information is not available at this time.'
      }));
    }
    if (!this.license.hasAtLeast('platinum')) {
      throw _boom.default.forbidden(_i18n.i18n.translate('xpack.maintenanceWindows.serverSideErrors.maintenanceWindow.invalidLicenseErrorMessage', {
        defaultMessage: 'Maintenance window is disabled because it requires a platinum license. Go to License Management to view upgrade options.'
      }));
    }
  }
}
exports.LicenseState = LicenseState;
function verifyApiAccessFactory(licenseState) {
  function verifyApiAccess() {
    const licenseCheckResults = licenseState.getLicenseInformation();
    if (licenseCheckResults.showAppLink && licenseCheckResults.enableAppLink) {
      return null;
    }
    throw _boom.default.forbidden(licenseCheckResults.message);
  }
  return verifyApiAccess;
}