"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindowStatus = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMaintenanceWindowStatus = () => {
  return {
    [_common.MaintenanceWindowStatus.Running]: '(maintenance-window.attributes.events: "now")',
    [_common.MaintenanceWindowStatus.Upcoming]: '(not maintenance-window.attributes.events: "now" and maintenance-window.attributes.events > "now")',
    [_common.MaintenanceWindowStatus.Finished]: '(not maintenance-window.attributes.events >= "now" and maintenance-window.attributes.expirationDate >"now")',
    [_common.MaintenanceWindowStatus.Archived]: '(maintenance-window.attributes.expirationDate < "now")',
    [_common.MaintenanceWindowStatus.Disabled]: '(maintenance-window.attributes.enabled: false)'
  };
};
exports.getMaintenanceWindowStatus = getMaintenanceWindowStatus;