"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchLogDocumentById = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchLogDocumentById = async ({
  id,
  data,
  logSourcesService
}, signal) => {
  const logSources = await logSourcesService.getLogSources();
  const indexPattern = logSources.map(source => source.indexPattern).join(',');
  const result = await (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [{
          field: '*',
          include_unmapped: true
        }],
        query: {
          term: {
            _id: id
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
  const hit = result.rawResponse.hits.hits[0];
  if (!hit) {
    return undefined;
  }
  return {
    _index: hit._index,
    fields: hit.fields
  };
};
exports.fetchLogDocumentById = fetchLogDocumentById;