"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryActionsMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18nReact = require("@kbn/i18n-react");
var _routerUtils = require("@kbn/router-utils");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_visibility_state = require("../../../utils/use_visibility_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/logging/log_entry_flyout/log_entry_actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryActionsMenu = ({
  logEntry
}) => {
  const {
    services: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    hide,
    isVisible,
    toggle
  } = (0, _use_visibility_state.useVisibilityState)(false);
  const apmLinkProps = (0, _react.useMemo)(() => getAPMLink({
    locators
  })(logEntry), [locators, logEntry]);
  const uptimeLinkProps = (0, _react.useMemo)(() => getUptimeLink({
    locators
  })(logEntry), [locators, logEntry]);
  const menuItems = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    "data-test-subj": "logEntryActionsMenuItem uptimeLogEntryActionsMenuItem",
    disabled: !uptimeLinkProps,
    icon: "uptimeApp",
    key: "uptimeLink"
  }, uptimeLinkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logEntryActionsMenu.uptimeActionLabel",
    defaultMessage: "View status in Uptime",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    "data-test-subj": "logEntryActionsMenuItem apmLogEntryActionsMenuItem",
    disabled: !apmLinkProps,
    icon: "apmApp",
    key: "apmLink"
  }, apmLinkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logEntryActionsMenu.apmActionLabel",
    defaultMessage: "View in APM",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }))], [apmLinkProps, uptimeLinkProps]);
  const hasMenuItems = (0, _react.useMemo)(() => menuItems.length > 0, [menuItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "logEntryActionsMenuButton",
      disabled: !hasMenuItems,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: toggle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsShared.logEntryActionsMenu.buttonLabel",
      defaultMessage: "Investigate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    })),
    closePopover: hide,
    id: "logEntryActionsMenu",
    isOpen: isVisible,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
};
exports.LogEntryActionsMenu = LogEntryActionsMenu;
const getUptimeLink = ({
  locators
}) => logEntry => {
  var _logEntry$fields$find, _logEntry$fields$find2, _logEntry$fields$find3, _logEntry$fields$find4, _logEntry$fields$find5, _logEntry$fields$find6, _logEntry$fields$find7, _logEntry$fields$find8;
  const uptimeLocator = locators.get(_deeplinksObservability.uptimeOverviewLocatorID);
  if (!uptimeLocator) {
    return undefined;
  }
  const ipValue = (_logEntry$fields$find = logEntry.fields.find(({
    field
  }) => field === 'host.ip')) === null || _logEntry$fields$find === void 0 ? void 0 : (_logEntry$fields$find2 = _logEntry$fields$find.value) === null || _logEntry$fields$find2 === void 0 ? void 0 : _logEntry$fields$find2[0];
  const containerValue = (_logEntry$fields$find3 = logEntry.fields.find(({
    field
  }) => field === 'container.id')) === null || _logEntry$fields$find3 === void 0 ? void 0 : (_logEntry$fields$find4 = _logEntry$fields$find3.value) === null || _logEntry$fields$find4 === void 0 ? void 0 : _logEntry$fields$find4[0];
  const podValue = (_logEntry$fields$find5 = logEntry.fields.find(({
    field
  }) => field === 'kubernetes.pod.uid')) === null || _logEntry$fields$find5 === void 0 ? void 0 : (_logEntry$fields$find6 = _logEntry$fields$find5.value) === null || _logEntry$fields$find6 === void 0 ? void 0 : _logEntry$fields$find6[0];
  const hostValue = (_logEntry$fields$find7 = logEntry.fields.find(({
    field
  }) => field === 'host.name')) === null || _logEntry$fields$find7 === void 0 ? void 0 : (_logEntry$fields$find8 = _logEntry$fields$find7.value) === null || _logEntry$fields$find8 === void 0 ? void 0 : _logEntry$fields$find8[0];
  const uptimeLocatorParams = {
    ...(typeof ipValue === 'string' && {
      ip: ipValue
    }),
    ...(typeof containerValue === 'string' && {
      container: containerValue
    }),
    ...(typeof podValue === 'string' && {
      pod: podValue
    }),
    ...(typeof hostValue === 'string' && {
      host: hostValue
    })
  };
  if (Object.keys(uptimeLocatorParams).length === 0) {
    return undefined;
  }

  // Coercing the return value to ContextRouterLinkProps because
  // EuiContextMenuItem defines a too broad type for onClick
  return (0, _routerUtils.getRouterLinkProps)({
    href: uptimeLocator.getRedirectUrl(uptimeLocatorParams),
    onClick: () => uptimeLocator.navigate(uptimeLocatorParams)
  });
};
const getAPMLink = ({
  locators
}) => logEntry => {
  var _logEntry$fields$find9, _logEntry$fields$find10;
  const traceId = (_logEntry$fields$find9 = logEntry.fields.find(({
    field,
    value
  }) => typeof value[0] === 'string' && field === 'trace.id')) === null || _logEntry$fields$find9 === void 0 ? void 0 : (_logEntry$fields$find10 = _logEntry$fields$find9.value) === null || _logEntry$fields$find10 === void 0 ? void 0 : _logEntry$fields$find10[0];
  if (typeof traceId !== 'string') {
    return undefined;
  }
  const apmLocator = locators.get(_deeplinksObservability.TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR);
  if (!apmLocator) {
    return undefined;
  }
  const timestampField = logEntry.fields.find(({
    field
  }) => field === '@timestamp');
  const timestamp = timestampField ? timestampField.value[0] : null;
  const {
    rangeFrom,
    rangeTo
  } = typeof timestamp === 'number' || typeof timestamp === 'string' ? (() => {
    const from = new Date(timestamp);
    const to = new Date(timestamp);
    from.setMinutes(from.getMinutes() - 10);
    to.setMinutes(to.getMinutes() + 10);
    return {
      rangeFrom: from.toISOString(),
      rangeTo: to.toISOString()
    };
  })() : {
    rangeFrom: 'now-1y',
    rangeTo: 'now'
  };
  const apmLocatorParams = {
    traceId,
    rangeFrom,
    rangeTo
  };

  // Coercing the return value to ContextRouterLinkProps because
  // EuiContextMenuItem defines a too broad type for onClick
  return (0, _routerUtils.getRouterLinkProps)({
    href: apmLocator.getRedirectUrl(apmLocatorParams),
    onClick: () => apmLocator.navigate(apmLocatorParams)
  });
};