"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSearchErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/data_search_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataSearchErrorCallout = ({
  errors,
  onRetry,
  title
}) => {
  const calloutColor = errors.some(error => error.type !== 'aborted') ? 'danger' : 'warning';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: calloutColor,
    iconType: "warning",
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, errors === null || errors === void 0 ? void 0 : errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement(DataSearchErrorMessage, {
    key: errorIndex,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })), onRetry ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraDataSearchErrorCalloutRetryButton",
    color: calloutColor,
    size: "s",
    onClick: onRetry,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.dataSearch.loadingErrorRetryButtonLabel",
    defaultMessage: "Retry",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  })) : null);
};
exports.DataSearchErrorCallout = DataSearchErrorCallout;
const DataSearchErrorMessage = ({
  error
}) => {
  if (error.type === 'aborted') {
    return /*#__PURE__*/_react.default.createElement(AbortedRequestErrorMessage, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    });
  } else if (error.type === 'shardFailure') {
    return /*#__PURE__*/_react.default.createElement(ShardFailureErrorMessage, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(GenericErrorMessage, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 12
      }
    });
  }
};
const AbortedRequestErrorMessage = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  tagName: "p",
  id: "xpack.logsShared.dataSearch.abortedRequestErrorMessage",
  defaultMessage: "The request was aborted.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 3
  }
});
const GenericErrorMessage = ({
  error
}) => {
  var _error$message;
  return /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 3
    }
  }, (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : `${error}`);
};
const ShardFailureErrorMessage = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  tagName: "p",
  id: "xpack.logsShared.dataSearch.shardFailureErrorMessage",
  defaultMessage: "Index {indexName}: {errorMessage}",
  values: {
    indexName: error.shardInfo.index,
    errorMessage: error.message
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 3
  }
});