"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openLinkEditorFlyout = openLinkEditorFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _kibana_services = require("../services/kibana_services");
var _link_editor = require("../components/editor/link_editor");
var _links_editor_tools = require("./links_editor_tools");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/editor/open_link_editor_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * This editor has no context about other links, so it cannot determine order; order will be determined
 * by the **caller** (i.e. the panel editor, which contains the context about **all links**)
 */

/**
 * @throws in case user cancels
 */
async function openLinkEditorFlyout({
  ref,
  link,
  mainFlyoutId,
  // used to manage the focus of this flyout after inidividual link editor flyout is closed
  parentDashboardId
}) {
  const unmountFlyout = async () => {
    if (ref.current) {
      ref.current.children[1].className = 'linkEditor out';
    }
    await new Promise(() => {
      // wait for close animation before unmounting
      setTimeout(() => {
        if (ref.current) _reactDom.default.unmountComponentAtNode(ref.current);
        (0, _links_editor_tools.focusMainFlyout)(mainFlyoutId);
      }, 180);
    });
  };
  return new Promise(resolve => {
    const onSave = async newLink => {
      resolve(newLink);
      await unmountFlyout();
    };
    const onCancel = async () => {
      resolve(undefined);
      await unmountFlyout();
    };
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, _kibana_services.coreServices, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_link_editor.LinkEditor, {
      link: link,
      onSave: onSave,
      onClose: onCancel,
      parentDashboardId: parentDashboardId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    })), ref.current);
  });
}