"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditorFlyout = getEditorFlyout;
var _react = _interopRequireDefault(require("react"));
var _uuid = require("uuid");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _content_management = require("../content_management");
var _links_editor = _interopRequireDefault(require("../components/editor/links_editor"));
var _resolve_links = require("../lib/resolve_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/editor/get_editor_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function getEditorFlyout({
  initialState,
  parentDashboard,
  onCompleteEdit,
  closeFlyout
}) {
  const flyoutId = `linksEditorFlyout-${(0, _uuid.v4)()}`;
  return /*#__PURE__*/_react.default.createElement(_links_editor.default, {
    flyoutId: flyoutId,
    initialLinks: initialState === null || initialState === void 0 ? void 0 : initialState.links,
    initialLayout: initialState === null || initialState === void 0 ? void 0 : initialState.layout,
    onClose: () => {
      onCompleteEdit === null || onCompleteEdit === void 0 ? void 0 : onCompleteEdit(undefined);
      closeFlyout();
    },
    onSaveToLibrary: async (newLinks, newLayout) => {
      const newState = {
        ...initialState,
        links: newLinks,
        layout: newLayout
      };
      if (initialState !== null && initialState !== void 0 && initialState.savedObjectId) {
        const {
          savedObjectId,
          ...updateState
        } = newState;
        await _content_management.linksClient.update({
          id: initialState.savedObjectId,
          data: {
            ...updateState,
            links: (0, _resolve_links.serializeResolvedLinks)(newLinks)
          },
          options: {
            references: []
          }
        });
        onCompleteEdit === null || onCompleteEdit === void 0 ? void 0 : onCompleteEdit(newState);
        closeFlyout();
      } else {
        const saveResult = await (0, _content_management.runSaveToLibrary)(newState);
        if (saveResult !== null && saveResult !== void 0 && saveResult.error) throw saveResult.error;
        onCompleteEdit === null || onCompleteEdit === void 0 ? void 0 : onCompleteEdit(saveResult);
        // If saveResult is undefined, the user cancelled the save as modal and we should not close the flyout
        if (saveResult) closeFlyout();
      }
    },
    onAddToDashboard: (newLinks, newLayout) => {
      const newState = {
        ...initialState,
        links: newLinks,
        layout: newLayout
      };
      onCompleteEdit === null || onCompleteEdit === void 0 ? void 0 : onCompleteEdit(newState);
      closeFlyout();
    },
    parentDashboardId: parentDashboard && (0, _presentationPublishing.apiPublishesSavedObjectId)(parentDashboard) ? parentDashboard.savedObjectId$.value : undefined,
    isByReference: Boolean(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectId),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
}