"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingValuesOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/expression-xy-plugin/public");
var _fitting_function_definitions = require("./fitting_function_definitions");
var _end_value_definitions = require("./end_value_definitions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/toolbar/appearance_settings/missing_values_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MissingValuesOptions = ({
  onFittingFnChange,
  fittingFunction,
  emphasizeFitting = true,
  onEmphasizeFittingChange,
  onEndValueChange,
  endValue,
  isFittingEnabled = true
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFittingEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.lens.xyChart.missingValuesHelpText', {
      defaultMessage: 'Select how you wish to treat gaps in data.'
    }),
    display: "columnCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.xyChart.missingValuesLabel', {
      defaultMessage: 'Missing values'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: _i18n.i18n.translate('xpack.lens.xyChart.missingValuesLabelHelpText', {
        defaultMessage: `By default, area and line charts hide the gaps in the data. To fill the gap, make a selection.`
      }),
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "lnsMissingValuesSelect",
    compressed: true,
    options: _fitting_function_definitions.fittingFunctionDefinitions.map(({
      id,
      title,
      description
    }) => {
      return {
        value: id,
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 23
          }
        }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 25
          }
        }, description))),
        inputDisplay: title
      };
    }),
    valueOfSelected: fittingFunction || _public.FittingFunctions.LINEAR,
    onChange: value => onFittingFnChange(value),
    itemLayoutAlign: "top",
    hasDividers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  })), fittingFunction && fittingFunction !== _public.FittingFunctions.NONE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.xyChart.endValuesLabel', {
      defaultMessage: 'End values'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "lnsEndValuesSelect",
    compressed: true,
    options: _end_value_definitions.endValueDefinitions.map(({
      id,
      title,
      description
    }) => {
      return {
        value: id,
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 27
          }
        }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 29
          }
        }, description))),
        inputDisplay: title
      };
    }),
    valueOfSelected: endValue || _public.FittingFunctions.NONE,
    onChange: value => onEndValueChange(value),
    itemLayoutAlign: "top",
    hasDividers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.missingValuesStyle', {
      defaultMessage: 'Show as dotted line'
    }),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    showLabel: false,
    label: _i18n.i18n.translate('xpack.lens.xyChart.missingValuesStyle', {
      defaultMessage: 'Show as dotted line'
    }),
    checked: !emphasizeFitting,
    onChange: () => {
      onEmphasizeFittingChange(!emphasizeFitting);
    },
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  })))));
};
exports.MissingValuesOptions = MissingValuesOptions;