"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitlesAndTextSettings = TitlesAndTextSettings;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/gauge/toolbar_component/titles_and_text_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TitlesAndTextSettings(props) {
  var _frame$activeData, _frame$activeData$sta, _frame$activeData$sta2;
  const {
    state,
    frame,
    inputValue,
    handleInputChange,
    subtitleMode,
    setSubtitleMode
  } = props;
  const metricDimensionTitle = state.layerId && ((_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$sta = _frame$activeData[state.layerId]) === null || _frame$activeData$sta === void 0 ? void 0 : (_frame$activeData$sta2 = _frame$activeData$sta.columns.find(col => col.id === state.metricAccessor)) === null || _frame$activeData$sta2 === void 0 ? void 0 : _frame$activeData$sta2.name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMajor",
    label: inputValue.labelMajor || '',
    mode: inputValue.labelMajorMode,
    placeholder: metricDimensionTitle || '',
    hasAutoOption: true,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMajor: value.label,
        labelMajorMode: value.mode
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMinor",
    label: inputValue.labelMinor || '',
    mode: subtitleMode,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMinor: value.mode === 'none' ? '' : value.label
      });
      setSubtitleMode(value.mode);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
}