"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allowedOrientations = exports.AxisLabelOrientationSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/axis/orientation/axis_label_orientation_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const allowedOrientations = exports.allowedOrientations = [0, -45, -90];
const orientationOptions = [{
  id: 'axis_orientation_horizontal',
  value: 0,
  label: _i18n.i18n.translate('xpack.lens.shared.axisOrientation.horizontal', {
    defaultMessage: 'Horizontal'
  })
}, {
  id: 'axis_orientation_vertical',
  value: -90,
  label: _i18n.i18n.translate('xpack.lens.shared.axisOrientation.vertical', {
    defaultMessage: 'Vertical'
  })
}, {
  id: 'axis_orientation_angled',
  value: -45,
  label: _i18n.i18n.translate('xpack.lens.shared.axisOrientation.angled', {
    defaultMessage: 'Angled'
  })
}];
const AxisLabelOrientationSelector = ({
  axis = 'x',
  selectedLabelOrientation,
  setLabelOrientation
}) => {
  var _orientationOptions$f, _orientationOptions$f2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.shared.axisOrientation.label', {
      defaultMessage: 'Orientation'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.shared.axisOrientation.label', {
      defaultMessage: 'Orientation'
    }),
    "data-test-subj": `lns${axis}AxisLabelRotationSelector`,
    buttonSize: "compressed",
    options: orientationOptions,
    idSelected: (_orientationOptions$f = (_orientationOptions$f2 = orientationOptions.find(({
      value
    }) => value === selectedLabelOrientation)) === null || _orientationOptions$f2 === void 0 ? void 0 : _orientationOptions$f2.id) !== null && _orientationOptions$f !== void 0 ? _orientationOptions$f : orientationOptions[0].id,
    onChange: optionId => {
      var _orientationOptions$f3, _orientationOptions$f4;
      const newOrientation = (_orientationOptions$f3 = (_orientationOptions$f4 = orientationOptions.find(({
        id
      }) => id === optionId)) === null || _orientationOptions$f4 === void 0 ? void 0 : _orientationOptions$f4.value) !== null && _orientationOptions$f3 !== void 0 ? _orientationOptions$f3 : orientationOptions[0].value;
      setLabelOrientation(newOrientation);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.AxisLabelOrientationSelector = AxisLabelOrientationSelector;