"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
var _lazy_builder = require("../lazy_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This type is to allow `visualizationType` to be `null` in the public context.
 *
 * The stored attributes must have a `visualizationType`.
 */

class LensClient {
  constructor(http) {
    (0, _defineProperty2.default)(this, "builder", void 0);
    this.http = http;
    this.builder = (0, _lazy_builder.getLensBuilder)();
  }
  async get(id) {
    var _this$builder, _this$builder2, _data$description;
    const {
      data,
      meta,
      id: responseId
    } = await this.http.get(`${_constants.LENS_VIS_API_PATH}/${id}`, {
      version: _constants.LENS_API_VERSION
    });
    const chartType = (_this$builder = this.builder) === null || _this$builder === void 0 ? void 0 : _this$builder.getType(data);
    if ((_this$builder2 = this.builder) !== null && _this$builder2 !== void 0 && _this$builder2.isSupported(chartType)) {
      const config = data;
      return {
        item: {
          ...this.builder.fromAPIFormat(config),
          id: responseId
        },
        meta
      };
    }
    if (!('state' in data)) {
      // This should never happen, only to typeguard until fully supported
      throw new Error('Failure to transform API Format');
    }
    return {
      item: {
        ...data,
        id: responseId,
        description: (_data$description = data.description) !== null && _data$description !== void 0 ? _data$description : undefined
      },
      meta
    };
  }
  async create({
    description,
    visualizationType,
    state,
    title,
    version
  }, references, options = {}) {
    var _this$builder3, _data$description2;
    if (visualizationType === null) {
      throw new Error('Missing visualization type');
    }
    const useApiFormat = (_this$builder3 = this.builder) === null || _this$builder3 === void 0 ? void 0 : _this$builder3.isSupported(visualizationType);
    const body = useApiFormat && this.builder ? this.builder.toAPIFormat({
      description,
      visualizationType,
      state,
      title,
      version,
      references
    }) : {
      description,
      visualizationType,
      state,
      title,
      version,
      references
    };
    const {
      data,
      meta,
      ...rest
    } = await this.http.post(_constants.LENS_VIS_API_PATH, {
      body: JSON.stringify(body),
      query: options,
      version: _constants.LENS_API_VERSION
    });
    if (useApiFormat && this.builder) {
      const config = data;
      return {
        item: {
          ...rest,
          ...this.builder.fromAPIFormat(config)
        },
        meta
      };
    }
    if (!('state' in data)) {
      // This should never happen, only to typeguard until fully supported
      throw new Error('Failure to transform API Format');
    }
    return {
      item: {
        ...rest,
        ...data,
        description: (_data$description2 = data.description) !== null && _data$description2 !== void 0 ? _data$description2 : undefined
      },
      meta
    };
  }
  async update(id, {
    description,
    visualizationType,
    state,
    title,
    version
  }, references, options = {}) {
    var _this$builder4, _data$description3;
    if (visualizationType === null) {
      throw new Error('Missing visualization type');
    }
    const useApiFormat = (_this$builder4 = this.builder) === null || _this$builder4 === void 0 ? void 0 : _this$builder4.isSupported(visualizationType);
    const body = useApiFormat && this.builder ? this.builder.toAPIFormat({
      description,
      visualizationType,
      state,
      title,
      version,
      references
    }) : {
      description,
      visualizationType,
      state,
      title,
      version,
      references
    };
    const {
      data,
      meta,
      ...rest
    } = await this.http.put(`${_constants.LENS_VIS_API_PATH}/${id}`, {
      body: JSON.stringify(body),
      query: options,
      version: _constants.LENS_API_VERSION
    });
    if (useApiFormat && this.builder) {
      const config = data;
      return {
        item: {
          ...rest,
          ...this.builder.fromAPIFormat(config)
        },
        meta
      };
    }
    if (!('state' in data)) {
      // This should never happen, only to typeguard until fully supported
      throw new Error('Failure to transform API Format');
    }
    return {
      item: {
        ...rest,
        ...data,
        description: (_data$description3 = data.description) !== null && _data$description3 !== void 0 ? _data$description3 : undefined
      },
      meta
    };
  }
  async delete(id) {
    var _response$response$ok, _response$response;
    const response = await this.http.delete(`${_constants.LENS_VIS_API_PATH}/${id}`, {
      asResponse: true,
      version: _constants.LENS_API_VERSION
    });
    const success = (_response$response$ok = (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.ok) !== null && _response$response$ok !== void 0 ? _response$response$ok : false;
    return {
      success
    };
  }
  async search({
    query,
    page,
    perPage,
    fields,
    searchFields
  }) {
    const result = await this.http.get(_constants.LENS_VIS_API_PATH, {
      query: {
        query,
        page,
        perPage,
        fields,
        searchFields
      },
      version: _constants.LENS_API_VERSION
    });
    return result.data.map(({
      id,
      data
    }) => {
      var _this$builder5, _this$builder6, _data$description4;
      const chartType = (_this$builder5 = this.builder) === null || _this$builder5 === void 0 ? void 0 : _this$builder5.getType(data);
      if ((_this$builder6 = this.builder) !== null && _this$builder6 !== void 0 && _this$builder6.isSupported(chartType)) {
        const config = data;
        return {
          id,
          ...this.builder.fromAPIFormat(config)
        };
      }
      if (!('state' in data)) {
        // This should never happen, only to typeguard until fully supported
        throw new Error('Failure to transform API Format');
      }
      return {
        id,
        ...data,
        description: (_data$description4 = data.description) !== null && _data$description4 !== void 0 ? _data$description4 : undefined
      };
    });
  }
}
exports.LensClient = LensClient;