"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensBuilder = getLensBuilder;
exports.setLensBuilder = setLensBuilder;
var _public = require("@kbn/kibana-utils-plugin/public");
var _get_feature_flags = require("./get_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const [getBuilder, setBuilder] = (0, _public.createGetterSetter)('LensBuilder', false);

/**
 * Retrieves the Lens builder
 */
function getLensBuilder() {
  const builder = getBuilder();
  const flags = (0, _get_feature_flags.getLensFeatureFlags)();
  if (!builder && flags.apiFormat) {
    // only throw if the feature flag is enabled and the builder is null
    throw new Error('Lens builder not initialized');
  }
  return builder;
}
async function setLensBuilder(useApiFormat) {
  if (useApiFormat) {
    const {
      LensConfigBuilder
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/lens-embeddable-utils')));
    const builder = new LensConfigBuilder(undefined, useApiFormat);
    setBuilder(builder);
    return builder;
  }
  return null;
}