"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/workspace_panel/message_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MessageList = ({
  messages,
  customButtonStyles
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  let warningCount = 0;
  let errorCount = 0;
  messages.forEach(({
    severity
  }) => {
    if (severity === 'warning') {
      warningCount++;
    } else {
      errorCount++;
    }
  });
  const buttonLabel = errorCount > 0 && warningCount > 0 ? _i18n.i18n.translate('xpack.lens.messagesButton.label.errorsAndWarnings', {
    defaultMessage: '{errorCount} {errorCount, plural, one {error} other {errors}}, {warningCount} {warningCount, plural, one {warning} other {warnings}}',
    values: {
      errorCount,
      warningCount
    }
  }) : errorCount > 0 ? _i18n.i18n.translate('xpack.lens.messagesButton.label.errors', {
    defaultMessage: '{errorCount} {errorCount, plural, one {error} other {errors}}',
    values: {
      errorCount
    }
  }) : _i18n.i18n.translate('xpack.lens.messagesButton.label.warnings', {
    defaultMessage: '{warningCount} {warningCount, plural, one {warning} other {warnings}}',
    values: {
      warningCount
    }
  });
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: buttonLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: 0,
      color: errorCount ? 'danger' : 'warning',
      onClick: onButtonClick,
      "data-test-subj": "lens-message-list-trigger",
      title: buttonLabel,
      css: customButtonStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, errorCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }), errorCount), warningCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "alert",
      css: (0, _react2.css)`
                    margin-left: 4px;
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 17
      }
    }), warningCount))),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    css: workspaceWarningListStyles.self,
    className: "eui-yScroll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, messages.map(({
    hidePopoverIcon = false,
    ...message
  }, index) => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    css: workspaceWarningListStyles.item,
    "data-test-subj": `lens-message-list-${message.severity}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, typeof message.longMessage === 'function' ? message.longMessage(closePopover) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    css: workspaceWarningListStyles.textItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, !hidePopoverIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  }, message.severity === 'error' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: workspaceWarningListStyles.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 19
    }
  }, message.longMessage)))))));
};
exports.MessageList = MessageList;
const workspaceWarningListStyles = {
  self: (0, _react2.css)`
    max-height: 320px;
    width: 256px;
  `,
  item: ({
    euiTheme
  }) => `
    & + & {
      border-top: 1px solid ${euiTheme.colors.lightShade};
    }
  `,
  textItem: ({
    euiTheme
  }) => `
     padding: ${euiTheme.size.base}
  `,
  description: (0, _react2.css)`
    overflow-wrap: break-word;
    min-width: 0;
  `
};