"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_SAVED_OBJECT_REF_NAME = void 0;
exports.findLensReference = findLensReference;
exports.isByRefLensConfig = isByRefLensConfig;
exports.isByRefLensState = isByRefLensState;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_SAVED_OBJECT_REF_NAME = exports.LENS_SAVED_OBJECT_REF_NAME = 'savedObjectRef';
function findLensReference(references) {
  return references ? references.find(ref => ref.type === _constants.DOC_TYPE && ref.name === LENS_SAVED_OBJECT_REF_NAME) : undefined;
}
function isByRefLensState(state) {
  return !state.attributes;
}
function isByRefLensConfig(config) {
  return !config.attributes;
}