"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromTermsLensApiToLensState = fromTermsLensApiToLensState;
exports.fromTermsLensStateToAPI = fromTermsLensStateToAPI;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getOrderByValue(rankBy, getMetricColumnIdByIndex) {
  var _rankBy$metric;
  if ((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'rare') {
    var _rankBy$max;
    return {
      type: 'rare',
      maxDocCount: (_rankBy$max = rankBy.max) !== null && _rankBy$max !== void 0 ? _rankBy$max : 1000
    };
  }
  if ((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'significant') {
    return {
      type: 'significant'
    };
  }
  if ((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'alphabetical') {
    return {
      type: 'alphabetical'
    };
  }
  if ((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'custom') {
    return {
      type: 'custom'
    };
  }
  const refId = getMetricColumnIdByIndex((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'column' ? (_rankBy$metric = rankBy.metric) !== null && _rankBy$metric !== void 0 ? _rankBy$metric : 0 : 0);
  if (!refId) {
    return {
      type: 'alphabetical',
      fallback: true
    };
  }
  return {
    type: 'column',
    columnId: refId
  };
}
function getOrderDirection(rankBy, getMetricColumnIdByIndex) {
  var _rankBy$metric2;
  if (rankBy && 'direction' in rankBy && rankBy.direction) {
    return rankBy.direction;
  }
  const refId = getMetricColumnIdByIndex((rankBy === null || rankBy === void 0 ? void 0 : rankBy.type) === 'column' ? (_rankBy$metric2 = rankBy.metric) !== null && _rankBy$metric2 !== void 0 ? _rankBy$metric2 : 0 : 0);
  return refId ? 'desc' : 'asc';
}
function fromTermsLensApiToLensState(options, getMetricColumnIdByIndex) {
  var _includes$as_regex, _excludes$as_regex, _rank_by$field;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    fields,
    size,
    increase_accuracy,
    includes,
    excludes,
    other_bucket,
    rank_by
  } = options;
  const [field, ...secondaryFields] = fields;
  const orderByConfig = getOrderByValue(rank_by, getMetricColumnIdByIndex);
  const orderDirection = getOrderDirection(rank_by, getMetricColumnIdByIndex);
  const format = (0, _format.fromFormatAPIToLensState)(options.format);
  return {
    operationType: 'terms',
    dataType: 'string',
    ...(0, _utils.getLensStateBucketSharedProps)({
      ...options,
      field
    }),
    params: {
      ...(secondaryFields.length ? {
        secondaryFields
      } : {}),
      size,
      // it cannot be 0 (zero)
      ...(increase_accuracy != null ? {
        accuracyMode: increase_accuracy
      } : {}),
      ...(includes !== null && includes !== void 0 && includes.values ? {
        include: includes === null || includes === void 0 ? void 0 : includes.values,
        includeIsRegex: (_includes$as_regex = includes === null || includes === void 0 ? void 0 : includes.as_regex) !== null && _includes$as_regex !== void 0 ? _includes$as_regex : false
      } : {}),
      ...(excludes !== null && excludes !== void 0 && excludes.values ? {
        exclude: excludes.values,
        excludeIsRegex: (_excludes$as_regex = excludes === null || excludes === void 0 ? void 0 : excludes.as_regex) !== null && _excludes$as_regex !== void 0 ? _excludes$as_regex : false
      } : {}),
      ...(other_bucket != null ? {
        otherBucket: true
      } : {}),
      ...((other_bucket === null || other_bucket === void 0 ? void 0 : other_bucket.include_documents_without_field) != null ? {
        missingBucket: other_bucket === null || other_bucket === void 0 ? void 0 : other_bucket.include_documents_without_field
      } : {}),
      orderBy: orderByConfig,
      orderDirection,
      ...((rank_by === null || rank_by === void 0 ? void 0 : rank_by.type) === 'custom' ? {
        orderAgg: {
          operationType: rank_by.operation,
          sourceField: (_rank_by$field = rank_by.field) !== null && _rank_by$field !== void 0 ? _rank_by$field : '',
          dataType: 'number',
          isBucketed: false,
          label: ''
        }
      } : {}),
      ...(format ? {
        format
      } : {}),
      parentFormat: {
        id: 'terms'
      }
    }
  };
}
function getRankByConfig(params, columns) {
  if (params.orderBy.type === 'alphabetical') {
    return {
      type: 'alphabetical',
      direction: params.orderDirection
    };
  }
  if (params.orderBy.type === 'rare') {
    return {
      type: 'rare',
      max: params.orderBy.maxDocCount
    };
  }
  if (params.orderBy.type === 'significant') {
    return {
      type: 'significant'
    };
  }
  if (params.orderBy.type === 'custom' && params.orderAgg &&
  // @ts-expect-error
  (0, _utils.isColumnOfReferableType)(params.orderAgg)) {
    return {
      type: 'custom',
      operation: params.orderAgg.operationType,
      field: params.orderAgg.sourceField,
      direction: params.orderDirection
    };
  }
  if (params.orderBy.type === 'column') {
    const index = columns.filter(({
      column
    }) => !column.isBucketed).findIndex(column => params.orderBy.type === 'column' && column.id === params.orderBy.columnId);
    if (index > -1) {
      return {
        type: 'column',
        metric: index,
        direction: params.orderDirection
      };
    }
  }
  return;
}
function fromTermsLensStateToAPI(column, columns) {
  var _column$params$second, _column$params$includ, _column$params$includ2, _column$params$exclud, _column$params$exclud2;
  const {
    label
  } = (0, _utils.getLensAPIBucketSharedProps)(column);
  return {
    operation: 'terms',
    fields: [column.sourceField].concat((_column$params$second = column.params.secondaryFields) !== null && _column$params$second !== void 0 ? _column$params$second : []),
    ...(label ? {
      label
    } : {}),
    size: column.params.size,
    ...(column.params.accuracyMode != null ? {
      increase_accuracy: column.params.accuracyMode
    } : {}),
    ...((_column$params$includ = column.params.include) !== null && _column$params$includ !== void 0 && _column$params$includ.length ? {
      includes: {
        as_regex: column.params.includeIsRegex,
        values: ((_column$params$includ2 = column.params.include) === null || _column$params$includ2 === void 0 ? void 0 : _column$params$includ2.map(value => String(value))) || []
      }
    } : {}),
    ...((_column$params$exclud = column.params.exclude) !== null && _column$params$exclud !== void 0 && _column$params$exclud.length ? {
      excludes: {
        as_regex: column.params.excludeIsRegex,
        values: ((_column$params$exclud2 = column.params.exclude) === null || _column$params$exclud2 === void 0 ? void 0 : _column$params$exclud2.map(value => String(value))) || []
      }
    } : {}),
    ...(column.params.otherBucket != null ? {
      other_bucket: {
        include_documents_without_field: Boolean(column.params.missingBucket)
      }
    } : {}),
    ...(column.params.orderBy ? {
      rank_by: getRankByConfig(column.params, columns)
    } : {})
  };
}