"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromDateHistogramLensApiToLensState = fromDateHistogramLensApiToLensState;
exports.fromDateHistogramLensStateToAPI = fromDateHistogramLensStateToAPI;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromDateHistogramLensApiToLensState(options) {
  const {
    field,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    suggested_interval,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    use_original_time_range,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    include_empty_rows,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    drop_partial_intervals,
    label
  } = options;
  return {
    operationType: 'date_histogram',
    dataType: 'date',
    ...(0, _utils.getLensStateBucketSharedProps)({
      label,
      field
    }),
    params: {
      interval: suggested_interval,
      includeEmptyRows: include_empty_rows,
      dropPartials: Boolean(drop_partial_intervals),
      ignoreTimeRange: use_original_time_range
    }
  };
}
function fromDateHistogramLensStateToAPI(column) {
  return {
    operation: 'date_histogram',
    ...(0, _utils.getLensAPIBucketSharedProps)(column),
    suggested_interval: column.params.interval,
    use_original_time_range: Boolean(column.params.ignoreTimeRange),
    include_empty_rows: Boolean(column.params.includeEmptyRows),
    drop_partial_intervals: Boolean(column.params.dropPartials)
  };
}