"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccessorNameForXY = getAccessorNameForXY;
exports.getIdForLayer = getIdForLayer;
exports.isAPIAnnotationLayer = isAPIAnnotationLayer;
exports.isAPIDataLayer = isAPIDataLayer;
exports.isAPIReferenceLineLayer = isAPIReferenceLineLayer;
exports.isAPIXYLayer = isAPIXYLayer;
exports.isAPIesqlXYLayer = isAPIesqlXYLayer;
exports.isLensStateDataLayer = isLensStateDataLayer;
var _utils = require("../../../utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getAccessorNameForXY(layer, accessorType, index) {
  if (index == null) {
    return `${layer.type}_${accessorType}`;
  }
  return `${layer.type}_${accessorType}_${index}`;
}
function getIdForLayer(layer, i) {
  return `${layer.type}_${i}`;
}
function isAPIAnnotationLayer(layer) {
  return _constants.XY_ANNOTATION_LAYER_TYPES.some(annotationType => annotationType === layer.type);
}
function isAPIReferenceLineLayer(layer) {
  return _constants.XY_REFERENCE_LAYER_TYPES.some(type => type === layer.type);
}
function isAPIDataLayer(layer) {
  return _constants.XY_DATA_LAYER_TYPES.some(type => type === layer.type);
}
function isAPIXYLayer(layer) {
  return typeof layer === 'object' && layer !== null && 'type' in layer && typeof layer.type === 'string' && _constants.AVAILABLE_XY_LAYER_TYPES.some(type => type === layer.type);
}
function isAPIesqlXYLayer(layer) {
  return (0, _utils.isEsqlTableTypeDataset)(layer.dataset);
}
function isLensStateDataLayer(layer) {
  return layer.layerType === 'data' || !('layerType' in layer);
}