"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasourceLayers = getDatasourceLayers;
exports.getMetricAccessor = getMetricAccessor;
exports.getSharedChartAPIToLensState = getSharedChartAPIToLensState;
exports.getSharedChartLensStateToAPI = getSharedChartLensStateToAPI;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getSharedChartLensStateToAPI(config) {
  var _config$title;
  return {
    // @TODO: need to make this optional in LensDocument type
    title: (_config$title = config.title) !== null && _config$title !== void 0 ? _config$title : '',
    ...(config.description != null ? {
      description: config.description
    } : {})
  };
}
function getSharedChartAPIToLensState(config) {
  var _config$title2;
  return {
    // @TODO: need to make this optional in LensDocument type
    title: (_config$title2 = config.title) !== null && _config$title2 !== void 0 ? _config$title2 : '',
    ...(config.description != null ? {
      description: config.description
    } : {})
  };
}
function getMetricAccessor(visualization) {
  var _visualization$metric;
  // @ts-expect-error Unfortunately for some obscure reasons there are SO out there with the accessor property instead of the correct one
  return (_visualization$metric = visualization.metricAccessor) !== null && _visualization$metric !== void 0 ? _visualization$metric : visualization.accessor;
}
function getDatasourceLayers(state) {
  var _state$datasourceStat, _state$datasourceStat2, _state$datasourceStat3;
  const formBasedLayers = (_state$datasourceStat = state.datasourceStates.formBased) === null || _state$datasourceStat === void 0 ? void 0 : _state$datasourceStat.layers;
  const textBasedLayers = (_state$datasourceStat2 = state.datasourceStates.textBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers;
  // @ts-expect-error unfortunately due to a migration bug, some existing SO might still have the old indexpattern DS state
  const indexPatternLayers = (_state$datasourceStat3 = state.datasourceStates.indexpattern) === null || _state$datasourceStat3 === void 0 ? void 0 : _state$datasourceStat3.layers;
  // Charts can have mixed layer types, so collect them all together
  return {
    ...(formBasedLayers && Object.keys(formBasedLayers).length ? formBasedLayers : {}),
    ...(textBasedLayers && Object.keys(textBasedLayers).length ? textBasedLayers : {}),
    ...(indexPatternLayers && Object.keys(indexPatternLayers).length ? indexPatternLayers : {})
  };
}