"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _coloring = require("../coloring");
var _types = require("../../types");
var _utils = require("../utils");
var _utils2 = require("./utils");
var _metric = require("../columns/metric");
var _esql_column = require("../columns/esql_column");
var _utils3 = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'gauge_accessor';
const LENS_DEFAULT_LAYER_ID = 'layer_0';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  var _layer$metric$ticks;
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    metricAccessor: getAccessorName('metric'),
    minAccessor: layer.metric.min ? getAccessorName('min') : undefined,
    maxAccessor: layer.metric.max ? getAccessorName('max') : undefined,
    goalAccessor: layer.metric.goal ? getAccessorName('goal') : undefined,
    shape: layer.shape ? layer.shape.type === 'bullet' ? layer.shape.direction === 'horizontal' ? 'horizontalBullet' : 'verticalBullet' : layer.shape.type : 'horizontalBullet',
    ...(layer.metric.color ? {
      colorMode: 'palette',
      palette: (0, _coloring.fromColorByValueAPIToLensState)(layer.metric.color)
    } : {}),
    ticksPosition: (_layer$metric$ticks = layer.metric.ticks) !== null && _layer$metric$ticks !== void 0 ? _layer$metric$ticks : 'auto',
    ...(layer.metric.hide_title ? {
      labelMajorMode: 'none'
    } : layer.metric.title ? {
      labelMajorMode: 'custom',
      labelMajor: layer.metric.title
    } : {
      labelMajorMode: 'auto'
    }),
    labelMinor: layer.metric.sub_title
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  const metricAccessor = (0, _utils2.getMetricAccessor)(visualization);
  if (metricAccessor == null) {
    throw new Error('Metric accessor is missing in the visualization state');
  }
  const dataset = (0, _utils.buildDatasetState)(layer, adHocDataViews, references, adhocReferences, layerId);
  if (!dataset || dataset.type == null) {
    throw new Error('Unsupported dataset type');
  }
  const props = {
    ...(0, _utils.generateApiLayer)(layer),
    shape: visualization.shape === 'horizontalBullet' ? {
      type: 'bullet',
      direction: 'horizontal'
    } : visualization.shape === 'verticalBullet' ? {
      type: 'bullet',
      direction: 'vertical'
    } : {
      type: visualization.shape
    },
    metric: (0, _utils3.isEsqlTableTypeDataset)(dataset) ? {
      ...(0, _esql_column.getValueApiColumn)(metricAccessor, layer),
      ...(visualization.minAccessor ? {
        min: (0, _esql_column.getValueApiColumn)(visualization.minAccessor, layer)
      } : {}),
      ...(visualization.maxAccessor ? {
        max: (0, _esql_column.getValueApiColumn)(visualization.maxAccessor, layer)
      } : {}),
      ...(visualization.goalAccessor ? {
        goal: (0, _esql_column.getValueApiColumn)(visualization.goalAccessor, layer)
      } : {})
    } : {
      ...(0, _utils.operationFromColumn)(metricAccessor, layer),
      ...(visualization.minAccessor ? {
        min: (0, _utils.operationFromColumn)(visualization.minAccessor, layer)
      } : {}),
      ...(visualization.maxAccessor ? {
        max: (0, _utils.operationFromColumn)(visualization.maxAccessor, layer)
      } : {}),
      ...(visualization.goalAccessor ? {
        goal: (0, _utils.operationFromColumn)(visualization.goalAccessor, layer)
      } : {})
    }
  };
  if (props.metric) {
    props.metric.hide_title = visualization.labelMajorMode === 'none';
    if (visualization.labelMajor) {
      props.metric.title = visualization.labelMajor;
    }
    if (visualization.labelMinor) {
      props.metric.sub_title = visualization.labelMinor;
    }
    if (visualization.ticksPosition) {
      props.metric.ticks = visualization.ticksPosition;
    }
    if (visualization.colorMode === 'palette' && visualization.palette) {
      props.metric.color = (0, _coloring.fromColorByValueLensStateToAPI)(visualization.palette);
    }
  }
  return {
    type: 'gauge',
    dataset: dataset,
    ...props
  };
}
function buildFormBasedLayer(layer) {
  const columns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = (0, _utils.generateLayer)(_types.DEFAULT_LAYER_ID, layer);
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('metric'), columns);
  if (layer.metric.min) {
    const columnName = getAccessorName('min');
    const newColumn = (0, _metric.fromMetricAPItoLensState)(layer.metric.min);
    (0, _utils.addLayerColumn)(defaultLayer, columnName, newColumn);
  }
  if (layer.metric.max) {
    const columnName = getAccessorName('max');
    const newColumn = (0, _metric.fromMetricAPItoLensState)(layer.metric.max);
    (0, _utils.addLayerColumn)(defaultLayer, columnName, newColumn);
  }
  if (layer.metric.goal) {
    const columnName = getAccessorName('goal');
    const newColumn = (0, _metric.fromMetricAPItoLensState)(layer.metric.goal);
    (0, _utils.addLayerColumn)(defaultLayer, columnName, newColumn);
  }
  return layers;
}
function getValueColumns(layer) {
  return [(0, _esql_column.getValueColumn)(getAccessorName('metric'), layer.metric.column, 'number'), ...(layer.metric.max ? [(0, _esql_column.getValueColumn)(getAccessorName('max'), layer.metric.max.column)] : []), ...(layer.metric.min ? [(0, _esql_column.getValueColumn)(getAccessorName('min'), layer.metric.min.column)] : []), ...(layer.metric.goal ? [(0, _esql_column.getValueColumn)(getAccessorName('goal'), layer.metric.goal.column)] : [])];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils.buildReferences)({
    [LENS_DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: 'lnsGauge',
    ...(0, _utils2.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}
function fromLensStateToAPI(config) {
  var _ref, _ref2, _state$datasourceStat, _state$datasourceStat2, _state$datasourceStat3, _state$datasourceStat4, _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (_ref = (_ref2 = (_state$datasourceStat = (_state$datasourceStat2 = state.datasourceStates.formBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers) !== null && _state$datasourceStat !== void 0 ? _state$datasourceStat : (_state$datasourceStat3 = state.datasourceStates.textBased) === null || _state$datasourceStat3 === void 0 ? void 0 : _state$datasourceStat3.layers) !== null && _ref2 !== void 0 ? _ref2 : // @ts-expect-error unfortunately due to a migration bug, some existing SO might still have the old indexpattern DS state
  (_state$datasourceStat4 = state.datasourceStates.indexpattern) === null || _state$datasourceStat4 === void 0 ? void 0 : _state$datasourceStat4.layers) !== null && _ref !== void 0 ? _ref : [];

  // Layers can be in any order, so make sure to get the main one
  const [layerId, layer] = Object.entries(layers).find(([, l]) => !('linkToLayers' in l) || l.linkToLayers == null);
  const visualizationState = {
    ...(0, _utils2.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : LENS_DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
  return visualizationState;
}